/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.LintResult;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.LintOptions;
import com.marcnuri.helm.jni.Result;
import java.nio.file.Path;
import java.util.Arrays;

public class LintCommand
extends HelmCommand<LintResult> {
    private final Path path;
    private boolean quiet = false;
    private boolean strict = false;

    public LintCommand(HelmLib helmLib, Path path) {
        super(helmLib);
        this.path = path;
    }

    @Override
    public LintResult call() {
        Result result = this.run(hl -> hl.Lint(new LintOptions(this.path.normalize().toFile().getAbsolutePath(), LintCommand.toInt(this.strict), LintCommand.toInt(this.quiet))));
        if (result.out == null || result.out.isEmpty()) {
            throw new IllegalStateException("Lint command returned no output");
        }
        String[] lines = result.out.split("\n");
        boolean failed = lines[lines.length - 1].equals("Failed: true");
        return new LintResult(Arrays.asList(lines).subList(0, lines.length - 1), failed);
    }

    public LintCommand quiet() {
        this.quiet = true;
        return this;
    }

    public LintCommand strict() {
        this.strict = true;
        return this;
    }
}

