/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.Helm;
import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.PackageOptions;
import java.nio.file.Path;

public class PackageCommand
extends HelmCommand<Helm> {
    private final Helm helm;
    private final Path path;
    private Path destination;
    private boolean sign;
    private String key;
    private Path keyring;
    private Path passphraseFile;

    public PackageCommand(HelmLib helmLib, Helm helm, Path path) {
        super(helmLib);
        this.helm = helm;
        this.path = path;
    }

    @Override
    public Helm call() {
        this.run(hl -> hl.Package(new PackageOptions(this.path.normalize().toFile().getAbsolutePath(), PackageCommand.toString(this.destination), PackageCommand.toInt(this.sign), this.key, PackageCommand.toString(this.keyring), PackageCommand.toString(this.passphraseFile))));
        return this.helm;
    }

    public PackageCommand withDestination(Path destination) {
        this.destination = destination;
        return this;
    }

    public PackageCommand sign() {
        this.sign = true;
        return this;
    }

    public PackageCommand withKey(String key) {
        this.key = key;
        return this;
    }

    public PackageCommand withKeyring(Path keyring) {
        this.keyring = keyring;
        return this;
    }

    public PackageCommand withPassphraseFile(Path passphraseFile) {
        this.passphraseFile = passphraseFile;
        return this;
    }
}

