/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.jni.Result;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Release {
    private final String name;
    private final String namespace;
    private final String status;
    private final String revision;
    private final ZonedDateTime lastDeployed;
    private final String chart;
    private final String appVersion;
    private final String output;

    private Release(String name, String namespace, String status, String revision, ZonedDateTime lastDeployed, String chart, String appVersion, String output) {
        this.name = name;
        this.namespace = namespace;
        this.status = status;
        this.revision = revision;
        this.lastDeployed = lastDeployed;
        this.chart = chart;
        this.appVersion = appVersion;
        this.output = output;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getStatus() {
        return this.status;
    }

    public String getRevision() {
        return this.revision;
    }

    public ZonedDateTime getLastDeployed() {
        return this.lastDeployed;
    }

    public String getChart() {
        return this.chart;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getOutput() {
        return this.output;
    }

    static Release parseSingle(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result cannot be null");
        }
        String out = result.out;
        if (out == null || out.isEmpty()) {
            throw new IllegalStateException("Result.out cannot be null or empty");
        }
        return new Release(Release.extract(out, "NAME"), Release.extract(out, "NAMESPACE"), Release.extract(out, "STATUS"), Release.extract(out, "REVISION"), Release.parse(Release.extract(out, "LAST DEPLOYED")), Release.extract(out, "CHART"), Release.extract(out, "APP VERSION"), out);
    }

    static List<Release> parseMultiple(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result cannot be null");
        }
        ArrayList<Release> releases = new ArrayList<Release>();
        for (Map<String, String> entries : HelmCommand.parseUrlEncodedLines(result.out)) {
            releases.add(new Release(entries.get("name"), entries.get("namespace"), entries.get("status"), entries.get("revision"), Release.parse(entries.get("lastDeployed")), entries.get("chart"), entries.get("appVersion"), ""));
        }
        return releases;
    }

    private static String extract(String out, String field) {
        int indexOfField = out.indexOf(field + ":");
        if (indexOfField == -1) {
            throw new IllegalStateException("Result.out does not contain " + field);
        }
        int indexOfNewLine = out.indexOf(10, indexOfField);
        if (indexOfNewLine == -1) {
            throw new IllegalStateException("Result.out does not contain " + field);
        }
        return out.substring(indexOfField + field.length() + 1, indexOfNewLine).trim();
    }

    private static ZonedDateTime parse(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        return ZonedDateTime.parse(date, DateTimeFormatter.RFC_1123_DATE_TIME);
    }
}

