/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.Repository;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.RepoOptions;
import com.marcnuri.helm.jni.Result;
import java.net.URI;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;

public class RepoCommand {
    private final HelmLib helmLib;

    public RepoCommand(HelmLib helmLib) {
        this.helmLib = helmLib;
    }

    public RepoSubcommand<Void> add() {
        return new RepoSubcommand<Void>(this.helmLib, hl -> arg_0 -> ((HelmLib)hl).RepoAdd(arg_0), r -> null);
    }

    public WithRepositoryConfig<List<Repository>> list() {
        return new RepoSubcommand<List<Repository>>(this.helmLib, hl -> arg_0 -> ((HelmLib)hl).RepoList(arg_0), Repository::parse);
    }

    public WithRepo<Void> remove() {
        return new RepoSubcommand<Void>(this.helmLib, hl -> arg_0 -> ((HelmLib)hl).RepoRemove(arg_0), r -> null);
    }

    public WithRepo<List<Repository>> update() {
        return new RepoSubcommand<List<Repository>>(this.helmLib, hl -> arg_0 -> ((HelmLib)hl).RepoUpdate(arg_0), Repository::parse);
    }

    public static interface RepoCallable<T>
    extends Callable<T> {
        @Override
        public T call();
    }

    public static interface WithRepo<T>
    extends WithRepositoryConfig<T> {
        @Override
        public WithRepo<T> withRepositoryConfig(Path var1);

        public WithRepo<T> withRepo(String var1);
    }

    public static interface WithRepositoryConfig<T>
    extends RepoCallable<T> {
        public WithRepositoryConfig<T> withRepositoryConfig(Path var1);
    }

    public static final class RepoSubcommand<T>
    extends HelmCommand<T>
    implements WithRepositoryConfig<T>,
    WithRepo<T> {
        private final Function<HelmLib, Function<RepoOptions, Result>> callable;
        private final Function<Result, T> transformer;
        private Path repositoryConfig;
        private String name;
        private final Set<String> names;
        private URI url;
        private String username;
        private String password;
        private Path certFile;
        private Path keyFile;
        private Path caFile;
        private boolean insecureSkipTlsVerify;

        RepoSubcommand(HelmLib helmLib, Function<HelmLib, Function<RepoOptions, Result>> callable, Function<Result, T> transformer) {
            super(helmLib);
            this.callable = callable;
            this.transformer = transformer;
            this.names = new LinkedHashSet<String>();
        }

        @Override
        public T call() {
            return this.transformer.apply(this.run(hl -> this.callable.apply((HelmLib)hl).apply(new RepoOptions(RepoSubcommand.toString(this.repositoryConfig), this.name, String.join((CharSequence)"\n", this.names), RepoSubcommand.toString(this.url), this.username, this.password, RepoSubcommand.toString(this.certFile), RepoSubcommand.toString(this.keyFile), RepoSubcommand.toString(this.caFile), RepoSubcommand.toInt(this.insecureSkipTlsVerify)))));
        }

        @Override
        public RepoSubcommand<T> withRepositoryConfig(Path repositoryConfig) {
            this.repositoryConfig = repositoryConfig;
            return this;
        }

        @Override
        public RepoSubcommand<T> withRepo(String repo) {
            this.names.add(repo);
            return this;
        }

        public RepoSubcommand<T> withName(String name) {
            this.name = name;
            return this;
        }

        public RepoSubcommand<T> withUrl(URI url) {
            this.url = url;
            return this;
        }

        public RepoSubcommand<T> withUsername(String username) {
            this.username = username;
            return this;
        }

        public RepoSubcommand<T> withPassword(String password) {
            this.password = password;
            return this;
        }

        public RepoSubcommand<T> withCertFile(Path certFile) {
            this.certFile = certFile;
            return this;
        }

        public RepoSubcommand<T> withKeyFile(Path keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        public RepoSubcommand<T> withCaFile(Path caFile) {
            this.caFile = caFile;
            return this;
        }

        public RepoSubcommand<T> insecureSkipTlsVerify() {
            this.insecureSkipTlsVerify = true;
            return this;
        }
    }
}

