/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.SearchResult;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.Result;
import com.marcnuri.helm.jni.SearchOptions;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;

public class SearchCommand {
    private final HelmLib helmLib;

    public SearchCommand(HelmLib helmLib) {
        this.helmLib = helmLib;
    }

    public SearchSubcommand<List<SearchResult>> repo() {
        return new SearchSubcommand<List<SearchResult>>(this.helmLib, hl -> arg_0 -> ((HelmLib)hl).SearchRepo(arg_0), SearchResult::parse);
    }

    public static final class SearchSubcommand<T>
    extends HelmCommand<T> {
        private final Function<HelmLib, Function<SearchOptions, Result>> callable;
        private final Function<Result, T> transformer;
        private Path repositoryConfig;
        private String keyword;
        private boolean regexp;
        private boolean devel;
        private String version;

        SearchSubcommand(HelmLib helmLib, Function<HelmLib, Function<SearchOptions, Result>> callable, Function<Result, T> transformer) {
            super(helmLib);
            this.callable = callable;
            this.transformer = transformer;
        }

        @Override
        public T call() {
            return this.transformer.apply(this.run(hl -> this.callable.apply((HelmLib)hl).apply(new SearchOptions(SearchSubcommand.toString(this.repositoryConfig), this.keyword, SearchSubcommand.toInt(this.regexp), SearchSubcommand.toInt(this.devel), this.version))));
        }

        public SearchSubcommand<T> withRepositoryConfig(Path repositoryConfig) {
            this.repositoryConfig = repositoryConfig;
            return this;
        }

        public SearchSubcommand<T> withKeyword(String keyword) {
            this.keyword = keyword;
            return this;
        }

        public SearchSubcommand<T> regexp() {
            this.regexp = true;
            return this;
        }

        public SearchSubcommand<T> devel() {
            this.devel = true;
            return this;
        }

        public SearchSubcommand<T> withVersion(String version) {
            this.version = version;
            return this;
        }
    }
}

