/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.jni.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchResult {
    private final String name;
    private final int score;
    private final String chartVersion;
    private final String appVersion;
    private final String description;
    private final String keywords;

    public SearchResult(String name, int score, String chartVersion, String appVersion, String description, String keywords) {
        this.name = name;
        this.score = score;
        this.chartVersion = chartVersion;
        this.appVersion = appVersion;
        this.description = description;
        this.keywords = keywords;
    }

    public String getName() {
        return this.name;
    }

    public int getScore() {
        return this.score;
    }

    public String getChartVersion() {
        return this.chartVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public static List<SearchResult> parse(Result result) {
        if (result == null) {
            throw new IllegalArgumentException("Result cannot be null");
        }
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>();
        for (Map<String, String> entries : HelmCommand.parseUrlEncodedLines(result.out)) {
            searchResults.add(new SearchResult(entries.get("name"), Integer.parseInt(entries.get("score")), entries.getOrDefault("chartVersion", ""), entries.getOrDefault("appVersion", ""), entries.getOrDefault("description", ""), entries.getOrDefault("keywords", "")));
        }
        return searchResults;
    }
}

