/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.Result;
import com.marcnuri.helm.jni.ShowOptions;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.function.Function;

public class ShowCommand {
    private final HelmLib helmLib;
    private final String chart;

    ShowCommand(HelmLib helmLib, Path path) {
        this.helmLib = helmLib;
        this.chart = HelmCommand.toString(path);
    }

    ShowCommand(HelmLib helmLib, String chart) {
        this.helmLib = helmLib;
        this.chart = chart;
    }

    public ShowSubcommand all() {
        return new ShowSubcommand(this.helmLib, this.chart, "all");
    }

    public ShowSubcommand chart() {
        return new ShowSubcommand(this.helmLib, this.chart, "chart");
    }

    public ShowSubcommand crds() {
        return new ShowSubcommand(this.helmLib, this.chart, "crds");
    }

    public ShowSubcommand readme() {
        return new ShowSubcommand(this.helmLib, this.chart, "readme");
    }

    public ShowSubcommand values() {
        return new ShowSubcommand(this.helmLib, this.chart, "values");
    }

    public static final class ShowSubcommand
    extends HelmCommand<String> {
        private final String chart;
        private final String outputFormat;
        private String version;
        private Path certFile;
        private Path keyFile;
        private Path caFile;
        private boolean insecureSkipTlsVerify;
        private boolean plainHttp;
        private boolean debug;

        private ShowSubcommand(HelmLib helmLib, String chart, String outputFormat) {
            super(helmLib);
            this.chart = chart;
            this.outputFormat = outputFormat;
        }

        @Override
        public String call() {
            return this.run((Function<HelmLib, Result>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$call$0(com.marcnuri.helm.jni.HelmLib ), (Lcom/marcnuri/helm/jni/HelmLib;)Lcom/marcnuri/helm/jni/Result;)((ShowSubcommand)this)).out;
        }

        public ShowSubcommand withVersion(String version) {
            this.version = version;
            return this;
        }

        public ShowSubcommand withCertFile(Path certFile) {
            this.certFile = certFile;
            return this;
        }

        public ShowSubcommand withKeyFile(Path keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        public ShowSubcommand withCaFile(Path caFile) {
            this.caFile = caFile;
            return this;
        }

        public ShowSubcommand insecureSkipTlsVerify() {
            this.insecureSkipTlsVerify = true;
            return this;
        }

        public ShowSubcommand plainHttp() {
            this.plainHttp = true;
            return this;
        }

        public ShowSubcommand debug() {
            this.debug = true;
            return this;
        }

        private /* synthetic */ Result lambda$call$0(HelmLib hl) {
            return hl.Show(new ShowOptions(this.chart, this.outputFormat, this.version, ShowSubcommand.toString(this.certFile), ShowSubcommand.toString(this.keyFile), ShowSubcommand.toString(this.caFile), ShowSubcommand.toInt(this.insecureSkipTlsVerify), ShowSubcommand.toInt(this.plainHttp), ShowSubcommand.toInt(this.debug)));
        }
    }
}

