/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.Release;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.TestOptions;
import java.nio.file.Path;

public class TestCommand
extends HelmCommand<Release> {
    private final String releaseName;
    private int timeout;
    private String namespace;
    private Path kubeConfig;
    private boolean debug;

    public TestCommand(HelmLib helmLib, String releaseName) {
        super(helmLib);
        this.releaseName = releaseName;
    }

    @Override
    public Release call() {
        return Release.parseSingle(this.run(hl -> hl.Test(new TestOptions(this.releaseName, this.timeout, this.namespace, TestCommand.toString(this.kubeConfig), TestCommand.toInt(this.debug)))));
    }

    public TestCommand withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TestCommand withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public TestCommand withKubeConfig(Path kubeConfig) {
        this.kubeConfig = kubeConfig;
        return this;
    }

    public TestCommand debug() {
        this.debug = true;
        return this;
    }
}

