/*
 * Decompiled with CFR 0.152.
 */
package com.marcnuri.helm;

import com.marcnuri.helm.DryRun;
import com.marcnuri.helm.HelmCommand;
import com.marcnuri.helm.Release;
import com.marcnuri.helm.jni.HelmLib;
import com.marcnuri.helm.jni.UpgradeOptions;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class UpgradeCommand
extends HelmCommand<Release> {
    private String name;
    private String chart;
    private String namespace;
    private boolean install;
    private boolean force;
    private boolean resetValues;
    private boolean reuseValues;
    private boolean resetThenReuseValues;
    private boolean atomic;
    private boolean cleanupOnFail;
    private boolean createNamespace;
    private String description;
    private boolean devel;
    private boolean dependencyUpdate;
    private boolean disableOpenApiValidation;
    private boolean dryRun;
    private DryRun dryRunOption;
    private boolean wait;
    private final Map<String, String> values;
    private Path kubeConfig;
    private Path certFile;
    private Path keyFile;
    private Path caFile;
    private boolean insecureSkipTlsVerify;
    private boolean plainHttp;
    private Path keyring;
    private boolean debug;
    private boolean clientOnly;

    public UpgradeCommand(HelmLib helmLib) {
        this(helmLib, null);
    }

    public UpgradeCommand(HelmLib helmLib, Path chart) {
        super(helmLib);
        this.chart = UpgradeCommand.toString(chart);
        this.values = new LinkedHashMap<String, String>();
    }

    @Override
    public Release call() {
        return Release.parseSingle(this.run(hl -> hl.Upgrade(new UpgradeOptions(this.name, this.chart, this.namespace, UpgradeCommand.toInt(this.install), UpgradeCommand.toInt(this.force), UpgradeCommand.toInt(this.resetValues), UpgradeCommand.toInt(this.reuseValues), UpgradeCommand.toInt(this.resetThenReuseValues), UpgradeCommand.toInt(this.atomic), UpgradeCommand.toInt(this.cleanupOnFail), UpgradeCommand.toInt(this.createNamespace), this.description, UpgradeCommand.toInt(this.devel), UpgradeCommand.toInt(this.dependencyUpdate), UpgradeCommand.toInt(this.disableOpenApiValidation), UpgradeCommand.toInt(this.dryRun), this.dryRunOption == null ? null : this.dryRunOption.name().toLowerCase(Locale.ROOT), UpgradeCommand.toInt(this.wait), UpgradeCommand.urlEncode(this.values), UpgradeCommand.toString(this.kubeConfig), UpgradeCommand.toString(this.certFile), UpgradeCommand.toString(this.keyFile), UpgradeCommand.toString(this.caFile), UpgradeCommand.toInt(this.insecureSkipTlsVerify), UpgradeCommand.toInt(this.plainHttp), UpgradeCommand.toString(this.keyring), UpgradeCommand.toInt(this.debug), UpgradeCommand.toInt(this.clientOnly)))));
    }

    public UpgradeCommand withName(String name) {
        this.name = name;
        return this;
    }

    UpgradeCommand withChart(String chart) {
        this.chart = chart;
        return this;
    }

    public UpgradeCommand withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public UpgradeCommand install() {
        this.install = true;
        return this;
    }

    public UpgradeCommand force() {
        this.force = true;
        return this;
    }

    public UpgradeCommand resetValues() {
        this.resetValues = true;
        return this;
    }

    public UpgradeCommand reuseValues() {
        this.reuseValues = true;
        return this;
    }

    public UpgradeCommand resetThenReuseValues() {
        this.resetThenReuseValues = true;
        return this;
    }

    public UpgradeCommand atomic() {
        this.atomic = true;
        return this;
    }

    public UpgradeCommand cleanupOnFail() {
        this.cleanupOnFail = true;
        return this;
    }

    public UpgradeCommand createNamespace() {
        this.createNamespace = true;
        return this;
    }

    public UpgradeCommand withDescription(String description) {
        this.description = description;
        return this;
    }

    public UpgradeCommand devel() {
        this.devel = true;
        return this;
    }

    public UpgradeCommand dependencyUpdate() {
        this.dependencyUpdate = true;
        return this;
    }

    public UpgradeCommand disableOpenApiValidation() {
        this.disableOpenApiValidation = true;
        return this;
    }

    public UpgradeCommand dryRun() {
        this.dryRun = true;
        return this;
    }

    public UpgradeCommand withDryRunOption(DryRun dryRunOption) {
        this.dryRunOption = dryRunOption;
        return this;
    }

    public UpgradeCommand waitReady() {
        this.wait = true;
        return this;
    }

    public UpgradeCommand set(String key, Object value) {
        this.values.put(key, value == null ? "" : value.toString());
        return this;
    }

    public UpgradeCommand withKubeConfig(Path kubeConfig) {
        this.kubeConfig = kubeConfig;
        return this;
    }

    public UpgradeCommand withCertFile(Path certFile) {
        this.certFile = certFile;
        return this;
    }

    public UpgradeCommand withKeyFile(Path keyFile) {
        this.keyFile = keyFile;
        return this;
    }

    public UpgradeCommand withCaFile(Path caFile) {
        this.caFile = caFile;
        return this;
    }

    public UpgradeCommand insecureSkipTlsVerify() {
        this.insecureSkipTlsVerify = true;
        return this;
    }

    public UpgradeCommand plainHttp() {
        this.plainHttp = true;
        return this;
    }

    public UpgradeCommand withKeyring(Path keyring) {
        this.keyring = keyring;
        return this;
    }

    public UpgradeCommand debug() {
        this.debug = true;
        return this;
    }

    public UpgradeCommand clientOnly() {
        this.clientOnly = true;
        return this;
    }
}

