/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.zuul.filters.pre.ratelimit.config.redis;

import com.marcosbarbero.zuul.filters.pre.ratelimit.config.Policy;
import com.marcosbarbero.zuul.filters.pre.ratelimit.config.Rate;
import com.marcosbarbero.zuul.filters.pre.ratelimit.config.RateLimiter;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisRateLimiter
implements RateLimiter {
    private final RedisTemplate template;

    public RedisRateLimiter(RedisTemplate template) {
        Assert.notNull((Object)template, (String)"RedisTemplate cannot be null");
        this.template = template;
    }

    @Override
    public Rate consume(Policy policy, String key) {
        Long limit = policy.getLimit();
        Long refreshInterval = policy.getRefreshInterval();
        Long current = this.template.boundValueOps((Object)key).increment(1L);
        Long expire = this.template.getExpire((Object)key);
        if (expire == null || expire == -1L) {
            this.template.expire((Object)key, refreshInterval.longValue(), TimeUnit.SECONDS);
            expire = refreshInterval;
        }
        return new Rate(limit, Math.max(-1L, limit - current), TimeUnit.SECONDS.toMillis(expire));
    }
}

