/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.hibernate.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marvinformatics.hibernate.json.JsonUserType;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.usertype.UserCollectionType;

public class JsonListUserType
extends JsonUserType
implements UserCollectionType {
    @Override
    public JavaType createJavaType(ObjectMapper mapper) {
        return mapper.getTypeFactory().constructCollectionType(List.class, this.returnedClass());
    }

    public PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        return new PersistentList(session);
    }

    private PersistentList cast(Object collection) {
        return (PersistentList)collection;
    }

    public PersistentCollection wrap(SessionImplementor session, Object collection) {
        return new PersistentList(session, (List)collection);
    }

    public Iterator<?> getElementsIterator(Object collection) {
        return this.cast(collection).iterator();
    }

    public boolean contains(Object collection, Object entity) {
        return this.cast(collection).contains(entity);
    }

    public Object indexOf(Object collection, Object entity) {
        return this.cast(collection).indexOf(entity);
    }

    public Object replaceElements(Object original, Object target, CollectionPersister persister, Object owner, Map copyCache, SessionImplementor session) throws HibernateException {
        PersistentList originalList = this.cast(original);
        PersistentList targetList = this.cast(target);
        targetList.clear();
        targetList.addAll((Collection)originalList);
        return target;
    }

    public Object instantiate(int anticipatedSize) {
        return new PersistentList();
    }
}

