/*
 * Decompiled with CFR 0.152.
 */
package com.marvinformatics.hibernate.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.DynamicParameterizedType;
import org.hibernate.usertype.UserType;
import org.postgresql.util.PGobject;

public class JsonUserType
implements UserType,
DynamicParameterizedType {
    private static final int[] SQL_TYPES = new int[]{2000};
    private Class<?> returnedClass;

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return null == x ? 0 : x.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        PGobject dataObject = new PGobject();
        dataObject.setType("json");
        if (value != null) {
            dataObject.setValue(this.convertObjectToJson(value));
        }
        st.setObject(index, dataObject);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Object result = rs.getObject(names[0]);
        if (result instanceof PGobject) {
            return this.convertJsonToObject(((PGobject)result).getValue());
        }
        return null;
    }

    Object convertJsonToObject(String content) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            JavaType type = this.createJavaType(mapper);
            if (type == null) {
                return mapper.readValue(content, this.returnedClass);
            }
            return mapper.readValue(content, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String convertObjectToJson(Object object) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        String json = this.convertObjectToJson(value);
        return this.convertJsonToObject(json);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public JavaType createJavaType(ObjectMapper mapper) {
        try {
            return SimpleType.construct(this.returnedClass());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public void setParameterValues(Properties parameters) {
        DynamicParameterizedType.ParameterType reader = (DynamicParameterizedType.ParameterType)parameters.get("org.hibernate.type.ParameterType");
        if (reader != null) {
            this.returnedClass = reader.getReturnedClass();
        }
    }

    public Class<?> returnedClass() {
        return this.returnedClass;
    }
}

