/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.drawable.StateListDrawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import com.marvinlabs.widget.slideshow.PlayList;
import com.marvinlabs.widget.slideshow.R;
import com.marvinlabs.widget.slideshow.SlideShowAdapter;
import com.marvinlabs.widget.slideshow.TransitionFactory;
import com.marvinlabs.widget.slideshow.playlist.RandomPlayList;
import com.marvinlabs.widget.slideshow.playlist.SequentialPlayList;
import com.marvinlabs.widget.slideshow.transition.FadeTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.FlipTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.NoTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.RandomTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.SlideAndZoomTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.ZoomTransitionFactory;

public class SlideShowView
extends RelativeLayout
implements View.OnClickListener {
    private Handler slideHandler;
    private View progressIndicator;
    private Status status = Status.STOPPED;
    private PlayList playlist = null;
    private SlideShowAdapter adapter = null;
    private TransitionFactory transitionFactory = null;
    private int notAvailableSlidesSkipped = 0;
    private OnSlideShowEventListener slideShowEventListener;
    private OnSlideClickListener slideClickListener;
    private StateListDrawable onClickedDrawable;
    private DataSetObserver adapterObserver = new DataSetObserver(){

        public void onChanged() {
            if (SlideShowView.this.adapter != null) {
                PlayList pl = SlideShowView.this.getPlaylist();
                pl.onSlideCountChanged(SlideShowView.this.adapter.getCount());
            }
        }

        public void onInvalidated() {
        }
    };
    SparseArray<View> recycledViews;
    private WaitSlideRunnable waitForCurrentSlide = new WaitSlideRunnable();
    private Runnable moveToNextSlide = new Runnable(){

        @Override
        public void run() {
            SlideShowView.this.next();
        }
    };

    public SlideShowView(Context context) {
        this(context, null, 0);
    }

    public SlideShowView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SlideShowView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise();
        this.readAttributeSet(context, attrs, defStyle);
    }

    private void readAttributeSet(Context context, AttributeSet attrs, int defStyle) {
        if (attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SlideShowView);
        try {
            this.onClickedDrawable = (StateListDrawable)a.getDrawable(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.onClickedDrawable == null) {
            TypedArray themeAttrs = context.getTheme().obtainStyledAttributes(new int[]{16843534});
            this.onClickedDrawable = (StateListDrawable)themeAttrs.getDrawable(0);
        }
        int playlistType = a.getInteger(1, 1);
        long slideDuration = a.getInteger(2, 5000);
        boolean loop = a.getBoolean(3, true);
        boolean autoAdvance = a.getBoolean(4, true);
        switch (playlistType) {
            case 2: {
                PlayList pl = new RandomPlayList();
                ((RandomPlayList)pl).setLooping(loop);
                ((RandomPlayList)pl).setSlideDuration(slideDuration);
                ((RandomPlayList)pl).setAutoAdvanceEnabled(autoAdvance);
                this.setPlaylist(pl);
                break;
            }
            default: {
                PlayList pl = new SequentialPlayList();
                ((SequentialPlayList)pl).setLooping(loop);
                ((SequentialPlayList)pl).setSlideDuration(slideDuration);
                ((SequentialPlayList)pl).setAutoAdvanceEnabled(autoAdvance);
                this.setPlaylist(pl);
            }
        }
        int transitionType = a.getInteger(5, 3);
        long transitionDuration = a.getInteger(6, 500);
        switch (transitionType) {
            case 1: {
                NoTransitionFactory tf = new NoTransitionFactory();
                this.setTransitionFactory(tf);
                break;
            }
            case 2: {
                RandomTransitionFactory tf = new RandomTransitionFactory(transitionDuration);
                this.setTransitionFactory(tf);
                break;
            }
            case 4: {
                ZoomTransitionFactory tf = new ZoomTransitionFactory(transitionDuration);
                this.setTransitionFactory(tf);
                break;
            }
            case 5: {
                SlideAndZoomTransitionFactory tf = new SlideAndZoomTransitionFactory(transitionDuration);
                this.setTransitionFactory(tf);
                break;
            }
            case 6: {
                FlipTransitionFactory tf = new FlipTransitionFactory(transitionDuration);
                tf.setDirection(FlipTransitionFactory.FlipAxis.HORIZONTAL);
                this.setTransitionFactory(tf);
                break;
            }
            case 7: {
                FlipTransitionFactory tf = new FlipTransitionFactory(transitionDuration);
                tf.setDirection(FlipTransitionFactory.FlipAxis.VERTICAL);
                this.setTransitionFactory(tf);
                break;
            }
            default: {
                FadeTransitionFactory tf = new FadeTransitionFactory(transitionDuration);
                this.setTransitionFactory(tf);
            }
        }
        a.recycle();
    }

    private void initialise() {
        this.slideHandler = new Handler();
        this.recycledViews = new SparseArray();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.slideHandler.removeCallbacksAndMessages(null);
        if (this.adapter != null) {
            this.adapter.unregisterDataSetObserver(this.adapterObserver);
        }
        super.onDetachedFromWindow();
    }

    protected void onFinishInflate() {
        this.progressIndicator = this.findViewById(R.id.progress_indicator);
        if (this.progressIndicator == null) {
            ProgressBar pb = new ProgressBar(this.getContext(), null, 16842872);
            pb.setIndeterminate(true);
            RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -2);
            lp.addRule(12);
            lp.addRule(9);
            pb.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.progressIndicator = pb;
        } else {
            this.removeView(this.progressIndicator);
        }
        super.onFinishInflate();
    }

    private void ensureComponentsAvailable() {
        if (this.adapter == null) {
            throw new RuntimeException("The SlideShowView needs an adapter (currently null)");
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.onClickedDrawable != null) {
            this.onClickedDrawable.setBounds(0, 0, w, h);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.onClickedDrawable != null) {
            this.onClickedDrawable.draw(canvas);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.onClickedDrawable != null) {
            this.onClickedDrawable.setState(this.getDrawableState());
            this.invalidate();
        }
    }

    public void onClick(View view) {
        this.notifySlideClicked();
    }

    public SlideShowAdapter getAdapter() {
        return this.adapter;
    }

    public void setAdapter(SlideShowAdapter adapter) {
        if (this.adapter != null) {
            this.adapter.unregisterDataSetObserver(this.adapterObserver);
        }
        this.adapter = adapter;
        this.adapter.registerDataSetObserver(this.adapterObserver);
        if (adapter != null) {
            PlayList pl = this.getPlaylist();
            pl.onSlideCountChanged(adapter.getCount());
            pl.rewind();
            this.prepareSlide(pl.getFirstSlide());
        }
    }

    public TransitionFactory getTransitionFactory() {
        if (this.transitionFactory == null) {
            this.transitionFactory = new FadeTransitionFactory();
        }
        return this.transitionFactory;
    }

    public void setTransitionFactory(TransitionFactory transitionFactory) {
        this.transitionFactory = transitionFactory;
    }

    public PlayList getPlaylist() {
        if (this.playlist == null) {
            this.setPlaylist(new SequentialPlayList());
        }
        return this.playlist;
    }

    public void setPlaylist(PlayList playlist) {
        this.playlist = playlist;
        if (this.adapter != null) {
            playlist.onSlideCountChanged(this.adapter.getCount());
        }
    }

    public void play() {
        this.ensureComponentsAvailable();
        this.getPlaylist().rewind();
        this.next();
    }

    public void next() {
        PlayList pl = this.getPlaylist();
        int previousPosition = pl.getCurrentSlide();
        pl.next();
        int currentPosition = pl.getCurrentSlide();
        this.playSlide(currentPosition, previousPosition);
    }

    public void previous() {
        PlayList pl = this.getPlaylist();
        int previousPosition = pl.getCurrentSlide();
        pl.previous();
        int currentPosition = pl.getCurrentSlide();
        this.playSlide(currentPosition, previousPosition);
    }

    public void stop() {
        this.status = Status.STOPPED;
        this.slideHandler.removeCallbacksAndMessages(null);
        this.removeAllViews();
        this.recycledViews.clear();
    }

    public void pause() {
        switch (this.status) {
            case PAUSED: 
            case STOPPED: {
                return;
            }
            case PLAYING: {
                this.status = Status.PAUSED;
                this.slideHandler.removeCallbacksAndMessages(null);
            }
        }
    }

    public void resume() {
        switch (this.status) {
            case PLAYING: {
                return;
            }
            case STOPPED: {
                this.play();
                return;
            }
        }
        this.status = Status.PLAYING;
        PlayList pl = this.getPlaylist();
        if (pl.isAutoAdvanceEnabled()) {
            this.slideHandler.removeCallbacks(this.moveToNextSlide);
            this.slideHandler.postDelayed(this.moveToNextSlide, pl.getSlideDuration(pl.getCurrentSlide()));
        }
    }

    public void togglePause() {
        if (this.status == Status.PLAYING) {
            this.pause();
        } else {
            this.resume();
        }
    }

    protected void playSlide(int currentPosition, int previousPosition) {
        SlideShowAdapter.SlideStatus slideStatus = this.adapter.getSlideStatus(currentPosition);
        PlayList pl = this.getPlaylist();
        if (currentPosition < 0) {
            this.stop();
            return;
        }
        this.slideHandler.removeCallbacksAndMessages(null);
        switch (slideStatus) {
            case READY: {
                this.notAvailableSlidesSkipped = 0;
                this.status = Status.PLAYING;
                if (pl.isAutoAdvanceEnabled()) {
                    this.slideHandler.postDelayed(this.moveToNextSlide, pl.getSlideDuration(currentPosition));
                }
                this.displaySlide(currentPosition, previousPosition);
                break;
            }
            case NOT_AVAILABLE: {
                Log.w((String)"SlideShowView", (String)("Slide is not available: " + currentPosition));
                ++this.notAvailableSlidesSkipped;
                if (this.notAvailableSlidesSkipped < this.adapter.getCount()) {
                    this.prepareSlide(pl.getNextSlide());
                    this.next();
                    break;
                }
                Log.w((String)"SlideShowView", (String)"Skipped too many slides in a row. Stopping playback.");
                this.stop();
                break;
            }
            case LOADING: {
                Log.d((String)"SlideShowView", (String)("Slide is not yet ready, waiting for it: " + currentPosition));
                this.showProgressIndicator();
                this.waitForCurrentSlide.startWaiting(currentPosition, previousPosition);
            }
        }
    }

    private void prepareSlide(int position) {
        if (this.adapter != null && position >= 0) {
            this.adapter.prepareSlide(position);
        }
    }

    private void displaySlide(final int currentPosition, final int previousPosition) {
        Log.v((String)"SlideShowView", (String)("Displaying slide at position: " + currentPosition));
        this.hideProgressIndicator();
        final View inView = this.getSlideView(currentPosition);
        inView.setVisibility(4);
        this.addView(inView);
        this.notifyBeforeSlideShown(currentPosition);
        TransitionFactory tf = this.getTransitionFactory();
        Animator inAnimator = tf.getInAnimator(inView, this, previousPosition, currentPosition);
        if (inAnimator != null) {
            inAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    inView.setVisibility(0);
                }

                public void onAnimationEnd(Animator animation) {
                    SlideShowView.this.notifySlideShown(currentPosition);
                }
            });
            inAnimator.start();
        } else {
            inView.setVisibility(0);
            this.notifySlideShown(currentPosition);
        }
        int childCount = this.getChildCount();
        if (childCount > 1) {
            this.notifyBeforeSlideHidden(previousPosition);
            final View outView = this.getChildAt(0);
            Animator outAnimator = tf.getOutAnimator(outView, this, previousPosition, currentPosition);
            if (outAnimator != null) {
                outAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        outView.setVisibility(4);
                        SlideShowView.this.notifySlideHidden(previousPosition);
                        SlideShowView.this.recyclePreviousSlideView(previousPosition, outView);
                    }
                });
                outAnimator.start();
            } else {
                outView.setVisibility(4);
                this.notifySlideHidden(previousPosition);
                this.recyclePreviousSlideView(previousPosition, outView);
            }
        }
    }

    private View getSlideView(int position) {
        int viewType = this.adapter.getItemViewType(position);
        View recycledView = (View)this.recycledViews.get(viewType);
        View v = this.adapter.getView(position, recycledView, (ViewGroup)this);
        return v;
    }

    private void recyclePreviousSlideView(int position, View view) {
        this.removeView(view);
        int viewType = this.adapter.getItemViewType(position);
        this.recycledViews.put(viewType, (Object)view);
        view.destroyDrawingCache();
        if (view instanceof ImageView) {
            ((ImageView)view).setImageDrawable(null);
        }
        Log.d((String)"SlideShowView", (String)("View added to recycling bin: " + view));
        this.adapter.discardSlide(position);
        this.prepareSlide(this.getPlaylist().getNextSlide());
    }

    protected void showProgressIndicator() {
        this.removeView(this.progressIndicator);
        this.progressIndicator.setAlpha(0.0f);
        this.addView(this.progressIndicator);
        this.progressIndicator.animate().alpha(1.0f).setDuration(500L).start();
    }

    protected void hideProgressIndicator() {
        this.removeView(this.progressIndicator);
    }

    public OnSlideShowEventListener getOnSlideShowEventListener() {
        return this.slideShowEventListener;
    }

    public void setOnSlideShowEventListener(OnSlideShowEventListener slideShowEventListener) {
        this.slideShowEventListener = slideShowEventListener;
    }

    private void notifySlideShown(int position) {
        if (this.slideShowEventListener != null) {
            this.slideShowEventListener.onSlideShown(this, position);
        }
    }

    private void notifySlideHidden(int position) {
        if (this.slideShowEventListener != null) {
            this.slideShowEventListener.onSlideHidden(this, position);
        }
    }

    private void notifyBeforeSlideShown(int position) {
        if (this.slideShowEventListener != null) {
            this.slideShowEventListener.beforeSlideShown(this, position);
        }
    }

    private void notifyBeforeSlideHidden(int position) {
        if (this.slideShowEventListener != null) {
            this.slideShowEventListener.beforeSlideHidden(this, position);
        }
    }

    public OnSlideClickListener getOnSlideClickListener() {
        return this.slideClickListener;
    }

    public void setOnSlideClickListener(OnSlideClickListener slideClickListener) {
        this.slideClickListener = slideClickListener;
        if (slideClickListener != null) {
            this.setClickable(true);
            this.setOnClickListener(this);
        } else {
            this.setClickable(false);
            this.setOnClickListener(null);
        }
    }

    private void notifySlideClicked() {
        if (this.slideClickListener != null) {
            this.slideClickListener.onItemClick(this, this.getPlaylist().getCurrentSlide());
        }
    }

    public static interface OnSlideClickListener {
        public void onItemClick(SlideShowView var1, int var2);
    }

    public static interface OnSlideShowEventListener {
        public void beforeSlideShown(SlideShowView var1, int var2);

        public void onSlideShown(SlideShowView var1, int var2);

        public void beforeSlideHidden(SlideShowView var1, int var2);

        public void onSlideHidden(SlideShowView var1, int var2);
    }

    private class WaitSlideRunnable
    implements Runnable {
        protected int currentSlide = 0;
        protected int previousSlide = 0;

        private WaitSlideRunnable() {
        }

        public void startWaiting(int currentSlide, int previousSlide) {
            this.currentSlide = currentSlide;
            this.previousSlide = previousSlide;
            SlideShowView.this.slideHandler.post((Runnable)this);
        }

        @Override
        public void run() {
            SlideShowAdapter.SlideStatus status = SlideShowView.this.adapter.getSlideStatus(this.currentSlide);
            switch (status) {
                case LOADING: {
                    SlideShowView.this.slideHandler.postDelayed((Runnable)this, 100L);
                    break;
                }
                default: {
                    SlideShowView.this.playSlide(this.currentSlide, this.previousSlide);
                }
            }
        }
    }

    private static enum Status {
        STOPPED,
        PAUSED,
        PLAYING;

    }
}

