/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.marvinlabs.widget.slideshow.SlideShowAdapter;
import java.lang.ref.WeakReference;

public abstract class BitmapAdapter
extends BaseAdapter
implements SlideShowAdapter {
    private Context context;
    private SparseArray<BitmapCache> cachedBitmaps;

    public BitmapAdapter(Context context) {
        this.context = context;
        this.cachedBitmaps = new SparseArray(3);
    }

    public Context getContext() {
        return this.context;
    }

    protected abstract void loadBitmap(int var1);

    protected void onBitmapLoaded(int position, Bitmap bitmap) {
        BitmapCache bc = (BitmapCache)this.cachedBitmaps.get(position);
        if (bc != null) {
            bc.status = bitmap == null ? SlideShowAdapter.SlideStatus.NOT_AVAILABLE : SlideShowAdapter.SlideStatus.READY;
            bc.bitmap = new WeakReference<Bitmap>(bitmap);
        }
    }

    protected void onBitmapNotAvailable(int position) {
        BitmapCache bc = (BitmapCache)this.cachedBitmaps.get(position);
        if (bc != null) {
            bc.status = SlideShowAdapter.SlideStatus.NOT_AVAILABLE;
            bc.bitmap = null;
        }
    }

    protected ImageView newImageViewInstance() {
        ImageView iv = new ImageView(this.context);
        iv.setScaleType(ImageView.ScaleType.CENTER_CROP);
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, -1);
        lp.addRule(10);
        lp.addRule(9);
        iv.setLayoutParams((ViewGroup.LayoutParams)lp);
        return iv;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ImageView iv = convertView == null ? this.newImageViewInstance() : (ImageView)convertView;
        BitmapCache bc = (BitmapCache)this.cachedBitmaps.get(position);
        if (bc == null) {
            this.prepareSlide(position);
            bc = (BitmapCache)this.cachedBitmaps.get(position);
        }
        if (bc != null && bc.status == SlideShowAdapter.SlideStatus.READY) {
            iv.setImageBitmap((Bitmap)bc.bitmap.get());
        }
        return iv;
    }

    @Override
    public void prepareSlide(int position) {
        BitmapCache bc = (BitmapCache)this.cachedBitmaps.get(position);
        if (bc != null && bc.bitmap != null && bc.bitmap.get() != null) {
            ((Bitmap)bc.bitmap.get()).recycle();
            bc.bitmap.clear();
        }
        bc = new BitmapCache();
        this.cachedBitmaps.put(position, (Object)bc);
        this.loadBitmap(position);
    }

    @Override
    public void discardSlide(int position) {
        BitmapCache bc = (BitmapCache)this.cachedBitmaps.get(position);
        if (bc != null && bc.bitmap != null && bc.bitmap.get() != null) {
            ((Bitmap)bc.bitmap.get()).recycle();
            bc.bitmap.clear();
        }
        this.cachedBitmaps.remove(position);
    }

    @Override
    public SlideShowAdapter.SlideStatus getSlideStatus(int position) {
        BitmapCache bc = (BitmapCache)this.cachedBitmaps.get(position);
        return bc != null ? bc.status : SlideShowAdapter.SlideStatus.NOT_AVAILABLE;
    }

    private static class BitmapCache {
        SlideShowAdapter.SlideStatus status = SlideShowAdapter.SlideStatus.LOADING;
        WeakReference<Bitmap> bitmap = null;

        private BitmapCache() {
        }
    }
}

