/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow.adapter;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Log;
import android.util.SparseArray;
import com.marvinlabs.widget.slideshow.adapter.BitmapAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class GenericBitmapAdapter<T>
extends BitmapAdapter {
    private List<T> items;
    private SparseArray<LoadBitmapTask> runningTasks;

    public GenericBitmapAdapter(Context context, Collection<T> items) {
        super(context);
        this.items = new ArrayList<T>(items);
        this.runningTasks = new SparseArray(3);
    }

    public int getCount() {
        return this.items.size();
    }

    public T getItem(int position) {
        return this.items.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @Override
    protected void loadBitmap(int position) {
        LoadBitmapTask task;
        if (position < 0 || position >= this.items.size()) {
            this.onBitmapNotAvailable(position);
        }
        if ((task = (LoadBitmapTask)((Object)this.runningTasks.get(position))) != null) {
            task.cancel(true);
        }
        task = new LoadBitmapTask(position);
        task.execute(new Object[]{this.items.get(position)});
    }

    @Override
    protected void onBitmapLoaded(int position, Bitmap bitmap) {
        Log.d((String)"GenericBitmapAdapter", (String)("Download finished for item " + position));
        this.runningTasks.remove(position);
        super.onBitmapLoaded(position, bitmap);
    }

    @Override
    protected void onBitmapNotAvailable(int position) {
        Log.d((String)"GenericBitmapAdapter", (String)("Download failed for item " + position));
        this.runningTasks.remove(position);
        super.onBitmapNotAvailable(position);
    }

    public void shutdown() {
        int taskCount = this.runningTasks.size();
        for (int i = 0; i < taskCount; ++i) {
            int key = this.runningTasks.keyAt(i);
            LoadBitmapTask t = (LoadBitmapTask)((Object)this.runningTasks.get(key));
            t.cancel(true);
        }
        this.runningTasks.clear();
    }

    protected abstract Bitmap asyncLoadBitmap(T var1, int var2);

    private class LoadBitmapTask
    extends AsyncTask<T, Void, Bitmap> {
        private int position;

        public LoadBitmapTask(int position) {
            this.position = position;
        }

        protected Bitmap doInBackground(T ... items) {
            Log.d((String)"GenericBitmapAdapter", (String)("Download started for item " + this.position));
            try {
                Bitmap bm = GenericBitmapAdapter.this.asyncLoadBitmap(items[0], this.position);
                if (this.isCancelled()) {
                    if (bm != null) {
                        bm.recycle();
                    }
                    return null;
                }
                return bm;
            }
            catch (Exception e) {
                Log.e((String)"GenericBitmapAdapter", (String)"Error while downloading image slide", (Throwable)e);
                e.printStackTrace();
                return null;
            }
        }

        protected void onPostExecute(Bitmap result) {
            if (result != null) {
                GenericBitmapAdapter.this.onBitmapLoaded(this.position, result);
            } else {
                GenericBitmapAdapter.this.onBitmapNotAvailable(this.position);
            }
        }
    }
}

