/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow.playlist;

import com.marvinlabs.widget.slideshow.PlayList;
import java.util.Arrays;
import java.util.Collections;

public class RandomPlayList
implements PlayList {
    public static final long DEFAULT_SLIDE_DURATION = 5000L;
    private int[] slideOrder = null;
    private int currentOrderIndex = -1;
    private boolean isLooping = true;
    private boolean isAutoAdvanceEnabled = true;
    private long slideDuration = 5000L;

    @Override
    public int getFirstSlide() {
        return this.getSlideCount() > 0 ? this.slideOrder[0] : -1;
    }

    @Override
    public int getCurrentSlide() {
        return this.getSlideCount() > 0 && this.currentOrderIndex >= 0 ? this.slideOrder[this.currentOrderIndex] : -1;
    }

    @Override
    public int getNextSlide() {
        if (this.currentOrderIndex < this.getSlideCount() - 1) {
            return this.slideOrder[this.currentOrderIndex + 1];
        }
        if (this.isLooping) {
            return this.slideOrder[0];
        }
        return -1;
    }

    @Override
    public int getPreviousSlide() {
        if (this.currentOrderIndex > 0) {
            return this.slideOrder[this.currentOrderIndex - 1];
        }
        if (this.isLooping) {
            return this.slideOrder[this.getSlideCount() - 1];
        }
        return -1;
    }

    @Override
    public void rewind() {
        this.currentOrderIndex = -1;
    }

    @Override
    public int next() {
        if (this.currentOrderIndex < this.getSlideCount() - 1) {
            ++this.currentOrderIndex;
        } else {
            if (this.isLooping) {
                this.currentOrderIndex = 0;
                return 0;
            }
            this.currentOrderIndex = -1;
        }
        return this.currentOrderIndex >= 0 ? this.slideOrder[this.currentOrderIndex] : -1;
    }

    @Override
    public int previous() {
        if (this.currentOrderIndex > 0) {
            return --this.currentOrderIndex;
        }
        if (this.isLooping) {
            this.currentOrderIndex = this.getSlideCount() - 1;
            return this.currentOrderIndex;
        }
        this.currentOrderIndex = -1;
        return this.currentOrderIndex >= 0 ? this.slideOrder[this.currentOrderIndex] : -1;
    }

    @Override
    public void onSlideCountChanged(int newSlideCount) {
        if (newSlideCount == 0) {
            this.slideOrder = null;
            return;
        }
        this.slideOrder = new int[newSlideCount];
        for (int i = 0; i < newSlideCount; ++i) {
            this.slideOrder[i] = i;
        }
        this.shuffle();
    }

    @Override
    public boolean isAutoAdvanceEnabled() {
        return this.isAutoAdvanceEnabled;
    }

    public void setAutoAdvanceEnabled(boolean isAutoAdvanceEnabled) {
        this.isAutoAdvanceEnabled = isAutoAdvanceEnabled;
    }

    public void shuffle() {
        if (this.slideOrder == null) {
            return;
        }
        int previousCurrentSlide = this.getCurrentSlide();
        Collections.shuffle(Arrays.asList(new int[][]{this.slideOrder}));
        if (previousCurrentSlide >= 0) {
            for (int i = 0; i < this.slideOrder.length; ++i) {
                if (this.slideOrder[i] != previousCurrentSlide) continue;
                this.currentOrderIndex = i;
                break;
            }
        }
    }

    public int getSlideCount() {
        return this.slideOrder == null ? 0 : this.slideOrder.length;
    }

    @Override
    public long getSlideDuration(int position) {
        return this.slideDuration;
    }

    public void setSlideDuration(long slideDuration) {
        this.slideDuration = slideDuration;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }
}

