/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow.playlist;

import com.marvinlabs.widget.slideshow.PlayList;

public class SequentialPlayList
implements PlayList {
    public static final long DEFAULT_SLIDE_DURATION = 5000L;
    private int slideCount = 0;
    private int currentSlide = -1;
    private boolean isLooping = true;
    private boolean isAutoAdvanceEnabled = true;
    private long slideDuration = 5000L;

    @Override
    public int getFirstSlide() {
        return this.slideCount > 0 ? 0 : -1;
    }

    @Override
    public int getCurrentSlide() {
        return this.currentSlide;
    }

    @Override
    public int getNextSlide() {
        if (this.currentSlide < this.slideCount - 1) {
            return this.currentSlide + 1;
        }
        if (this.isLooping) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getPreviousSlide() {
        if (this.currentSlide > 0) {
            return this.currentSlide - 1;
        }
        if (this.isLooping) {
            return this.slideCount - 1;
        }
        return -1;
    }

    @Override
    public void rewind() {
        this.currentSlide = -1;
    }

    @Override
    public int next() {
        this.currentSlide = this.getNextSlide();
        return this.currentSlide;
    }

    @Override
    public int previous() {
        this.currentSlide = this.getPreviousSlide();
        return this.currentSlide;
    }

    @Override
    public void onSlideCountChanged(int newSlideCount) {
        this.slideCount = newSlideCount;
        if (this.currentSlide >= newSlideCount) {
            this.currentSlide = this.slideCount - 1;
        }
    }

    @Override
    public boolean isAutoAdvanceEnabled() {
        return this.isAutoAdvanceEnabled;
    }

    public void setAutoAdvanceEnabled(boolean isAutoAdvanceEnabled) {
        this.isAutoAdvanceEnabled = isAutoAdvanceEnabled;
    }

    @Override
    public long getSlideDuration(int position) {
        return this.slideDuration;
    }

    public void setSlideDuration(long slideDuration) {
        this.slideDuration = slideDuration;
    }

    public boolean isLooping() {
        return this.isLooping;
    }

    public void setLooping(boolean isLooping) {
        this.isLooping = isLooping;
    }
}

