/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow.transition;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.util.Property;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.marvinlabs.widget.slideshow.SlideShowView;
import com.marvinlabs.widget.slideshow.transition.BaseTransitionFactory;

public class FlipTransitionFactory
extends BaseTransitionFactory {
    private FlipAxis axis;

    public FlipTransitionFactory() {
        this(500L, (Interpolator)new LinearInterpolator(), FlipAxis.VERTICAL);
    }

    public FlipTransitionFactory(long duration) {
        this(duration, (Interpolator)new LinearInterpolator(), FlipAxis.VERTICAL);
    }

    public FlipTransitionFactory(long duration, Interpolator interpolator) {
        this(duration, interpolator, FlipAxis.VERTICAL);
    }

    public FlipTransitionFactory(long duration, FlipAxis axis) {
        this(duration, (Interpolator)new LinearInterpolator(), axis);
    }

    public FlipTransitionFactory(long duration, Interpolator interpolator, FlipAxis axis) {
        super(duration, interpolator);
        this.axis = axis;
    }

    public FlipAxis getAxis() {
        return this.axis;
    }

    public void setDirection(FlipAxis axis) {
        this.axis = axis;
    }

    @Override
    public Animator getInAnimator(View target, SlideShowView parent, int fromSlide, int toSlide) {
        PropertyValuesHolder rotation;
        target.setAlpha(1.0f);
        target.setScaleX(1.0f);
        target.setScaleY(1.0f);
        target.setTranslationX(0.0f);
        target.setTranslationY(0.0f);
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{0.0f, 1.0f});
        switch (this.axis) {
            case VERTICAL: {
                target.setRotationX(-90.0f);
                target.setRotationY(0.0f);
                rotation = PropertyValuesHolder.ofFloat((Property)View.ROTATION_X, (float[])new float[]{0.0f});
                break;
            }
            default: {
                target.setRotationX(0.0f);
                target.setRotationY(-90.0f);
                rotation = PropertyValuesHolder.ofFloat((Property)View.ROTATION_Y, (float[])new float[]{0.0f});
            }
        }
        ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{rotation});
        animator.setDuration(this.getDuration() / 2L);
        animator.setStartDelay(this.getDuration() / 2L);
        animator.setInterpolator((TimeInterpolator)this.getInterpolator());
        return animator;
    }

    @Override
    public Animator getOutAnimator(View target, SlideShowView parent, int fromSlide, int toSlide) {
        PropertyValuesHolder rotation;
        PropertyValuesHolder alpha = PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.0f});
        switch (this.axis) {
            case VERTICAL: {
                target.setRotationX(0.0f);
                target.setRotationY(0.0f);
                rotation = PropertyValuesHolder.ofFloat((Property)View.ROTATION_X, (float[])new float[]{90.0f});
                break;
            }
            default: {
                target.setRotationX(0.0f);
                target.setRotationY(0.0f);
                rotation = PropertyValuesHolder.ofFloat((Property)View.ROTATION_Y, (float[])new float[]{90.0f});
            }
        }
        ObjectAnimator animator = ObjectAnimator.ofPropertyValuesHolder((Object)target, (PropertyValuesHolder[])new PropertyValuesHolder[]{rotation});
        animator.setDuration(this.getDuration() / 2L);
        animator.setInterpolator((TimeInterpolator)this.getInterpolator());
        return animator;
    }

    public static enum FlipAxis {
        HORIZONTAL,
        VERTICAL;

    }
}

