/*
 * Decompiled with CFR 0.152.
 */
package com.marvinlabs.widget.slideshow.transition;

import android.animation.Animator;
import android.view.View;
import android.view.animation.Interpolator;
import com.marvinlabs.widget.slideshow.SlideShowView;
import com.marvinlabs.widget.slideshow.TransitionFactory;
import com.marvinlabs.widget.slideshow.transition.BaseTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.FadeTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.FlipTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.SlideAndZoomTransitionFactory;
import com.marvinlabs.widget.slideshow.transition.ZoomTransitionFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomTransitionFactory
extends BaseTransitionFactory {
    private static final Random RAND = new Random();
    private final List<TransitionFactory> factories = new ArrayList<TransitionFactory>();
    private TransitionFactory currentFactory;

    public RandomTransitionFactory() {
        this(500L, DEFAULT_INTERPOLATOR);
    }

    public RandomTransitionFactory(long duration) {
        this(duration, DEFAULT_INTERPOLATOR);
    }

    public RandomTransitionFactory(long duration, Interpolator interpolator) {
        super(duration, interpolator);
        this.factories.add(new FadeTransitionFactory(this.getDuration(), this.getInterpolator()));
        this.factories.add(new ZoomTransitionFactory(this.getDuration(), this.getInterpolator()));
        this.factories.add(new SlideAndZoomTransitionFactory(this.getDuration(), this.getInterpolator()));
        this.factories.add(new FlipTransitionFactory(this.getDuration(), this.getInterpolator()));
    }

    @Override
    public Animator getInAnimator(View target, SlideShowView parent, int fromSlide, int toSlide) {
        int r = RAND.nextInt(this.factories.size());
        this.currentFactory = this.factories.get(r);
        return this.currentFactory.getInAnimator(target, parent, fromSlide, toSlide);
    }

    @Override
    public Animator getOutAnimator(View target, SlideShowView parent, int fromSlide, int toSlide) {
        return this.currentFactory.getOutAnimator(target, parent, fromSlide, toSlide);
    }

    static {
        RAND.setSeed(System.currentTimeMillis());
    }
}

