/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.collect;

import com.mebigfatguy.fbcontrib.collect.ImmutabilityType;
import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.CollectionUtils;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class CollectMethodsReturningImmutableCollections
extends BytecodeScanningDetector
implements NonReportingDetector {
    private static Set<String> IMMUTABLE_PRODUCING_METHODS = new HashSet<String>();
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private String clsName;
    private ImmutabilityType imType;

    public CollectMethodsReturningImmutableCollections(BugReporter reporter) {
        this.bugReporter = reporter;
    }

    public void visitClassContext(ClassContext context) {
        try {
            this.stack = new OpcodeStack();
            this.clsName = context.getJavaClass().getClassName();
            super.visitClassContext(context);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        try {
            String signature = Type.getReturnType((String)this.getMethod().getSignature()).getSignature();
            if (signature.startsWith("L") && CollectionUtils.isListSetMap(signature.substring(1, signature.length() - 1))) {
                this.stack.resetForMethodEntry((DismantleBytecode)this);
                this.imType = ImmutabilityType.UNKNOWN;
                super.visitCode(obj);
                if (this.imType == ImmutabilityType.IMMUTABLE || this.imType == ImmutabilityType.POSSIBLY_IMMUTABLE) {
                    Method m = this.getMethod();
                    Statistics.getStatistics().addImmutabilityStatus(this.clsName, m.getName(), m.getSignature(), this.imType);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        ImmutabilityType seenImmutable = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 184: {
                    String className = this.getClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    if (IMMUTABLE_PRODUCING_METHODS.contains(className + '.' + methodName)) {
                        seenImmutable = ImmutabilityType.IMMUTABLE;
                        break;
                    }
                }
                case 182: 
                case 183: 
                case 185: {
                    String className = this.getClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    MethodInfo mi = Statistics.getStatistics().getMethodStatistics(className, methodName, signature);
                    seenImmutable = mi.getImmutabilityType();
                    if (seenImmutable != ImmutabilityType.UNKNOWN) break;
                    seenImmutable = null;
                    break;
                }
                case 176: {
                    if (this.stack.getStackDepth() <= 0) break;
                    item = this.stack.getStackItem(0);
                    ImmutabilityType type = (ImmutabilityType)((Object)item.getUserValue());
                    if (type == null) {
                        type = ImmutabilityType.UNKNOWN;
                    }
                    block6 : switch (this.imType) {
                        case UNKNOWN: {
                            switch (type) {
                                case IMMUTABLE: {
                                    this.imType = ImmutabilityType.IMMUTABLE;
                                    break block6;
                                }
                                case POSSIBLY_IMMUTABLE: {
                                    this.imType = ImmutabilityType.POSSIBLY_IMMUTABLE;
                                    break block6;
                                }
                            }
                            this.imType = ImmutabilityType.MUTABLE;
                            break;
                        }
                        case IMMUTABLE: {
                            if (type == ImmutabilityType.IMMUTABLE) break;
                            this.imType = ImmutabilityType.POSSIBLY_IMMUTABLE;
                            break;
                        }
                        case POSSIBLY_IMMUTABLE: {
                            break;
                        }
                        case MUTABLE: {
                            if (type != ImmutabilityType.IMMUTABLE) break;
                            this.imType = ImmutabilityType.POSSIBLY_IMMUTABLE;
                            break;
                        }
                    }
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (seenImmutable == null) throw throwable;
            if (this.stack.getStackDepth() <= 0) throw throwable;
            OpcodeStack.Item item2 = this.stack.getStackItem(0);
            item2.setUserValue(seenImmutable);
            throw throwable;
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (seenImmutable == null) return;
        if (this.stack.getStackDepth() <= 0) return;
        item = this.stack.getStackItem(0);
        item.setUserValue((Object)seenImmutable);
    }

    static {
        IMMUTABLE_PRODUCING_METHODS.add("com/google/common/Collect/Maps.immutableEnumMap");
        IMMUTABLE_PRODUCING_METHODS.add("com/google/common/Collect/Maps.unmodifiableMap");
        IMMUTABLE_PRODUCING_METHODS.add("com/google/common/Collect/Sets.immutableEnumSet");
        IMMUTABLE_PRODUCING_METHODS.add("com/google/common/Collect/Sets.immutableCopy");
        IMMUTABLE_PRODUCING_METHODS.add("java/util/Arrays.asList");
        IMMUTABLE_PRODUCING_METHODS.add("java/util/Collections.unmodifiableCollection");
        IMMUTABLE_PRODUCING_METHODS.add("java/util/Collections.unmodifiableSet");
        IMMUTABLE_PRODUCING_METHODS.add("java/util/Collections.unmodifiableSortedSet");
        IMMUTABLE_PRODUCING_METHODS.add("java/util/Collections.unmodifiableMap");
        IMMUTABLE_PRODUCING_METHODS.add("java/util/Collections.unmodifiableList");
        IMMUTABLE_PRODUCING_METHODS.add("edu/emory/mathcs/backport/java/util/Arrays.asList");
        IMMUTABLE_PRODUCING_METHODS.add("edu/emory/mathcs/backport/java/util/Collections.unmodifiableCollection");
        IMMUTABLE_PRODUCING_METHODS.add("edu/emory/mathcs/backport/java/util/Collections.unmodifiableSet");
        IMMUTABLE_PRODUCING_METHODS.add("edu/emory/mathcs/backport/java/util/Collections.unmodifiableSortedSet");
        IMMUTABLE_PRODUCING_METHODS.add("edu/emory/mathcs/backport/java/util/Collections.unmodifiableMap");
        IMMUTABLE_PRODUCING_METHODS.add("edu/emory/mathcs/backport/java/util/Collections.unmodifiableList");
    }
}

