/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.collect;

import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class CollectStatistics
extends BytecodeScanningDetector
implements NonReportingDetector {
    private static Set<String> COMMON_METHOD_SIGS = new HashSet<String>();
    private int numMethodCalls;
    private boolean classHasAnnotation;

    public CollectStatistics(BugReporter bugReporter) {
        Statistics.getStatistics().clear();
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass cls = classContext.getJavaClass();
        AnnotationEntry[] annotations = cls.getAnnotationEntries();
        this.classHasAnnotation = annotations != null && annotations.length > 0;
        super.visitClassContext(classContext);
    }

    public void visitCode(Code obj) {
        this.numMethodCalls = 0;
        byte[] code = obj.getCode();
        if (code != null) {
            super.visitCode(obj);
            String clsName = this.getClassName();
            int accessFlags = this.getMethod().getAccessFlags();
            MethodInfo mi = Statistics.getStatistics().addMethodStatistics(clsName, this.getMethodName(), this.getMethodSig(), accessFlags, obj.getLength(), this.numMethodCalls);
            if (clsName.contains("$") || (accessFlags & 0x2600) != 0) {
                mi.addCallingAccess(1);
            } else if ((accessFlags & 2) == 0) {
                if (this.isAssociationedWithAnnotations(this.getMethod())) {
                    mi.addCallingAccess(1);
                } else {
                    String methodSig = this.getMethodName() + this.getMethodSig();
                    for (String sig : COMMON_METHOD_SIGS) {
                        if (!methodSig.matches(sig)) continue;
                        mi.addCallingAccess(1);
                    }
                }
            }
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                ++this.numMethodCalls;
                break;
            }
        }
    }

    private boolean isAssociationedWithAnnotations(Method m) {
        if (this.classHasAnnotation) {
            return true;
        }
        AnnotationEntry[] annotations = m.getAnnotationEntries();
        return annotations != null && annotations.length > 0;
    }

    static {
        COMMON_METHOD_SIGS.add("\\<init\\>\\(\\)V");
        COMMON_METHOD_SIGS.add("toString\\(\\)Ljava/lang/String;");
        COMMON_METHOD_SIGS.add("hashCode\\(\\)I");
        COMMON_METHOD_SIGS.add("clone\\(\\).*");
        COMMON_METHOD_SIGS.add("values\\(\\).*");
        COMMON_METHOD_SIGS.add("main\\(\\[Ljava/lang/String;\\)V");
    }
}

