/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class AbnormalFinallyBlockReturn
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private List<FinallyBlockInfo> fbInfo;
    private int loadedReg;

    public AbnormalFinallyBlockReturn(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            int majorVersion = classContext.getJavaClass().getMajor();
            if (majorVersion >= 48) {
                this.fbInfo = new ArrayList<FinallyBlockInfo>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.fbInfo = null;
        }
    }

    public void visitCode(Code obj) {
        this.fbInfo.clear();
        this.loadedReg = -1;
        CodeException[] exc = obj.getExceptionTable();
        if (exc != null) {
            for (CodeException ce : exc) {
                if (ce.getCatchType() != 0 || ce.getStartPC() != ce.getHandlerPC()) continue;
                this.fbInfo.add(new FinallyBlockInfo(ce.getStartPC()));
            }
        }
        if (!this.fbInfo.isEmpty()) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (this.fbInfo.isEmpty()) {
            return;
        }
        FinallyBlockInfo fbi = this.fbInfo.get(0);
        if (this.getPC() < fbi.startPC) {
            return;
        }
        if (this.getPC() == fbi.startPC) {
            if (!OpcodeUtils.isAStore(seen)) {
                this.fbInfo.remove(0);
                this.sawOpcode(seen);
                return;
            }
            fbi.exReg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
            return;
        }
        if (seen == 194) {
            ++fbi.monitorCount;
        } else if (seen == 195) {
            --fbi.monitorCount;
            if (fbi.monitorCount < 0) {
                this.fbInfo.remove(0);
                this.sawOpcode(seen);
                return;
            }
        }
        if (seen == 191 && this.loadedReg == fbi.exReg) {
            this.fbInfo.remove(0);
            this.sawOpcode(seen);
            return;
        }
        this.loadedReg = OpcodeUtils.isALoad(seen) ? RegisterUtils.getALoadReg((DismantleBytecode)this, seen) : -1;
        if (seen >= 172 && seen <= 177 || seen == 191) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AFBR_ABNORMAL_FINALLY_BLOCK_RETURN.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            this.fbInfo.remove(0);
        } else if (seen == 182 || seen == 185 || seen == 183 || seen == 184) {
            try {
                ExceptionTable et;
                JavaClass cls = Repository.lookupClass((String)this.getClassConstantOperand());
                Method m = AbnormalFinallyBlockReturn.findMethod(cls, this.getNameConstantOperand(), this.getSigConstantOperand());
                if (m != null && (et = m.getExceptionTable()) != null && et.getLength() > 0 && !this.catchBlockInFinally(fbi)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AFBR_ABNORMAL_FINALLY_BLOCK_RETURN.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.fbInfo.remove(0);
                }
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    private static Method findMethod(JavaClass cls, String name, String sig) {
        Method[] methods;
        for (Method m : methods = cls.getMethods()) {
            if (!m.getName().equals(name) || !m.getSignature().equals(sig)) continue;
            return m;
        }
        return null;
    }

    private boolean catchBlockInFinally(FinallyBlockInfo fBlockInfo) {
        CodeException[] catchExceptions = this.getCode().getExceptionTable();
        if (catchExceptions == null || catchExceptions.length == 0) {
            return false;
        }
        int pc = this.getPC();
        for (CodeException ex : catchExceptions) {
            if (ex.getStartPC() > pc || ex.getEndPC() < pc || ex.getStartPC() < fBlockInfo.startPC) continue;
            return true;
        }
        return false;
    }

    static class FinallyBlockInfo {
        public int startPC;
        public int monitorCount;
        public int exReg;

        FinallyBlockInfo(int start) {
            this.startPC = start;
            this.monitorCount = 0;
            this.exReg = -1;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

