/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class ArrayWrappedCallByReference
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private Map<Integer, WrapperInfo> wrappers;

    public ArrayWrappedCallByReference(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.wrappers = new HashMap<Integer, WrapperInfo>(10);
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.wrappers = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(188) || bytecodeSet.get(189));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.wrappers.clear();
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Integer userValue = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 188: 
                case 189: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    Integer size = (Integer)itm.getConstant();
                    if (size == null) return;
                    if (size != 1) return;
                    userValue = Values.NEGATIVE_ONE;
                    return;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    if (this.stack.getStackDepth() < 2) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(2);
                    int reg = itm.getRegisterNumber();
                    if (reg != -1) {
                        WrapperInfo wi = this.wrappers.get(reg);
                        if (wi == null) return;
                        OpcodeStack.Item elItm = this.stack.getStackItem(0);
                        wi.wrappedReg = elItm.getRegisterNumber();
                        return;
                    }
                    OpcodeStack.Item elItm = this.stack.getStackItem(0);
                    if (elItm.getRegisterNumber() == -1) return;
                    userValue = elItm.getRegisterNumber();
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    if (this.stack.getStackDepth() < 1) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    String sig = itm.getSignature();
                    if (sig.length() > 0 && itm.getSignature().charAt(0) == '[') {
                        int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                        Integer elReg = (Integer)itm.getUserValue();
                        if (elReg == null) return;
                        this.wrappers.put(reg, new WrapperInfo(elReg));
                        return;
                    }
                    Integer elReg = (Integer)itm.getUserValue();
                    if (elReg == null) return;
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    if (elReg != reg) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AWCBR_ARRAY_WRAPPED_CALL_BY_REFERENCE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String sig = this.getSigConstantOperand();
                    Type[] args = Type.getArgumentTypes((String)sig);
                    if (this.stack.getStackDepth() < args.length) return;
                    int i = 0;
                    while (i < args.length) {
                        OpcodeStack.Item itm;
                        int arrayReg;
                        WrapperInfo wi;
                        Type t = args[i];
                        String argSig = t.getSignature();
                        if (argSig.length() > 0 && argSig.charAt(0) == '[' && (wi = this.wrappers.get(arrayReg = (itm = this.stack.getStackItem(args.length - i - 1)).getRegisterNumber())) != null) {
                            wi.wasArg = true;
                        }
                        ++i;
                    }
                    return;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    if (this.stack.getStackDepth() < 2) return;
                    OpcodeStack.Item arItm = this.stack.getStackItem(1);
                    int arReg = arItm.getRegisterNumber();
                    WrapperInfo wi = this.wrappers.get(arReg);
                    if (wi == null) return;
                    if (!wi.wasArg) return;
                    userValue = wi.wrappedReg;
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    WrapperInfo wi = this.wrappers.get(reg);
                    if (wi == null) return;
                    userValue = wi.wrappedReg;
                    return;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: {
                    if (this.stack.getStackDepth() < 1) return;
                    OpcodeStack.Item itm = this.stack.getStackItem(0);
                    Integer elReg = (Integer)itm.getUserValue();
                    if (elReg == null) return;
                    int reg = RegisterUtils.getStoreReg((DismantleBytecode)this, seen);
                    if (elReg != reg) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.AWCBR_ARRAY_WRAPPED_CALL_BY_REFERENCE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (userValue != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)userValue);
            }
        }
    }

    static class WrapperInfo {
        int wrappedReg;
        boolean wasArg;

        WrapperInfo(int reg) {
            this.wrappedReg = reg;
            this.wasArg = false;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

