/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.PublicAPI;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class CharsetIssues
extends BytecodeScanningDetector {
    private static final String CHARSET_SIG = "Ljava/nio/charset/Charset;";
    private static final Map<String, Integer> REPLACEABLE_ENCODING_METHODS;
    private static final Map<String, Integer> UNREPLACEABLE_ENCODING_METHODS;
    public static final Set<String> STANDARD_JDK7_ENCODINGS;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private int classVersion;

    public CharsetIssues(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.classVersion = classContext.getJavaClass().getMajor();
            if (this.classVersion >= 48) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
        }
    }

    public void visitMethod(Method obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String encoding = null;
                    String className = this.getClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    String methodSig = this.getSigConstantOperand();
                    String methodInfo = className + '.' + methodName + methodSig;
                    Integer stackOffset = REPLACEABLE_ENCODING_METHODS.get(methodInfo);
                    if (stackOffset != null) {
                        OpcodeStack.Item item;
                        int offset = stackOffset;
                        if (this.stack.getStackDepth() > offset && STANDARD_JDK7_ENCODINGS.contains(encoding = (String)(item = this.stack.getStackItem(offset)).getConstant()) && this.classVersion >= 51) {
                            String changedMethodSig = CharsetIssues.replaceNthArgWithCharsetString(methodSig, offset);
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CSI_CHAR_SET_ISSUES_USE_STANDARD_CHARSET.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this).addCalledMethod(className, methodName, changedMethodSig, seen == 184));
                        }
                    } else {
                        Integer offsetValue = UNREPLACEABLE_ENCODING_METHODS.get(methodInfo);
                        if (offsetValue != null) {
                            OpcodeStack.Item item;
                            int offset = offsetValue;
                            if (this.stack.getStackDepth() > offset && STANDARD_JDK7_ENCODINGS.contains(encoding = (String)(item = this.stack.getStackItem(offset)).getConstant()) && this.classVersion >= 51) {
                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CSI_CHAR_SET_ISSUES_USE_STANDARD_CHARSET_NAME.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this));
                            }
                        }
                    }
                    if (encoding == null) return;
                    try {
                        Charset.forName(encoding);
                        return;
                    }
                    catch (IllegalArgumentException e) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CSI_CHAR_SET_ISSUES_UNKNOWN_ENCODING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addCalledMethod((DismantleBytecode)this).addString(encoding));
                        return;
                    }
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private static String replaceNthArgWithCharsetString(String sig, Integer stackOffset) {
        Type[] arguments = Type.getArgumentTypes((String)sig);
        StringBuilder sb = new StringBuilder("(");
        int argumentIndexToReplace = arguments.length - stackOffset - 1;
        for (int i = 0; i < arguments.length; ++i) {
            if (i == argumentIndexToReplace) {
                sb.append(CHARSET_SIG);
                continue;
            }
            sb.append(arguments[i].getSignature());
        }
        sb.append(sig.substring(sig.lastIndexOf(41), sig.length()));
        return sb.toString();
    }

    @PublicAPI(value="Used by fb-contrib-eclipse-quickfixes to determine type of fix to apply")
    public static Map<String, Integer> getUnreplaceableCharsetEncodings() {
        return UNREPLACEABLE_ENCODING_METHODS;
    }

    @PublicAPI(value="Used by fb-contrib-eclipse-quickfixes to determine type of fix to apply")
    public static Map<String, Integer> getReplaceableCharsetEncodings() {
        return REPLACEABLE_ENCODING_METHODS;
    }

    static {
        HashMap<String, Integer> replaceable = new HashMap<String, Integer>(8);
        replaceable.put("java/io/InputStreamReader.<init>(Ljava/io/InputStream;Ljava/lang/String;)V", Values.ZERO);
        replaceable.put("java/io/OutputStreamWriter.<init>(Ljava/io/OutputStream;Ljava/lang/String;)V", Values.ZERO);
        replaceable.put("java/lang/String.<init>([BLjava/lang/String;)V", Values.ZERO);
        replaceable.put("java/lang/String.<init>([BIILjava/lang/String;)V", Values.ZERO);
        replaceable.put("java/lang/String.getBytes(Ljava/lang/String;)[B", Values.ZERO);
        replaceable.put("java/util/Formatter.<init>(Ljava/io/File;Ljava/lang/String;Ljava/util/Locale;)V", Values.ONE);
        REPLACEABLE_ENCODING_METHODS = Collections.unmodifiableMap(replaceable);
        HashMap<String, Integer> unreplaceable = new HashMap<String, Integer>(32);
        unreplaceable.put("java/net/URLEncoder.encode(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", Values.ZERO);
        unreplaceable.put("java/net/URLDecoder.decode(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", Values.ZERO);
        unreplaceable.put("java/io/ByteArrayOutputStream.toString(Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/io/PrintStream.<init>(Ljava/lang/String;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/io/PrintStream.<init>(Ljava/io/File;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/io/PrintStream.<init>(Ljava/io/OutputStream;BLjava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/io/PrintStream.toCharset(Ljava/lang/String;)Ljava/nio/charset/Charset;", Values.ZERO);
        unreplaceable.put("java/io/PrintWriter.<init>(Ljava/lang/String;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/io/PrintWriter.<init>(Ljava/io/File;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/io/PrintWriter.toCharset(Ljava/lang/String;)Ljava/nio/charset/Charset;", Values.ZERO);
        unreplaceable.put("java/lang/StringCoding.decode(Ljava/lang/String;[BII)[C", Values.THREE);
        unreplaceable.put("java/lang/StringCoding.encode(Ljava/lang/String;[CII)[B", Values.THREE);
        unreplaceable.put("java/util/Formatter.<init>(Ljava/io/File;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Formatter.<init>(Ljava/io/OutputStream;Ljava/lang/String;Ljava/util/Locale;)V", Values.ONE);
        unreplaceable.put("java/util/Formatter.<init>(Ljava/io/OutputStream;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Formatter.<init>(Ljava/lang/String;Ljava/lang/String;Ljava/util/Locale;)V", Values.ONE);
        unreplaceable.put("java/util/Formatter.<init>(Ljava/lang/String;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Formatter.toCharset(Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/logging/Handler.setEncoding(Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/logging/MemoryHandler.setEncoding(Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/logging/StreamHandler.setEncoding(Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Scanner.<init>(Ljava/io/File;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Scanner.<init>(Ljava/io/InputStream;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Scanner.<init>(Ljava/nio/file/Path;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/util/Scanner.<init>(Ljava/nio/channels/ReadableByteChannel;Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/lang/StringCoding.decode(Ljava/lang/String;[BII)[C", Values.THREE);
        unreplaceable.put("java/lang/StringCoding.encode(Ljava/lang/String;[CII)[B", Values.THREE);
        unreplaceable.put("javax/servlet/ServletResponse.setCharacterEncoding(Ljava/lang/String;)V", Values.ZERO);
        unreplaceable.put("java/beans/XMLEncoder.<init>(Ljava/io/OutputStream;Ljava/lang/String;ZI)V", Values.TWO);
        unreplaceable.put("java/nio/channels/Channels.newReader(Ljava/nio/channels/ReadableByteChannel;Ljava/lang/String;)Ljava/io/Reader;", Values.ZERO);
        unreplaceable.put("java/nio/channels/Channels.newWriter(Ljava/nio/channels/WritableByteChannel;Ljava/lang/String;)Ljava/io/Writer;", Values.ZERO);
        UNREPLACEABLE_ENCODING_METHODS = Collections.unmodifiableMap(unreplaceable);
        HashSet<String> encodings = new HashSet<String>();
        encodings.add("US-ASCII");
        encodings.add("ISO-8859-1");
        encodings.add("UTF-8");
        encodings.add("UTF-16BE");
        encodings.add("UTF-16LE");
        encodings.add("UTF-16");
        STANDARD_JDK7_ENCODINGS = Collections.unmodifiableSet(encodings);
    }
}

