/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;

public class CircularDependencies
extends BytecodeScanningDetector {
    private Map<String, Set<String>> dependencyGraph = null;
    private BugReporter bugReporter;
    private String clsName;

    public CircularDependencies(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.dependencyGraph = new HashMap<String, Set<String>>();
    }

    public void visit(JavaClass obj) {
        this.clsName = obj.getClassName();
    }

    public void sawOpcode(int seen) {
        if (seen == 183 || seen == 184 || seen == 182) {
            String refClsName = this.getClassConstantOperand();
            if ((refClsName = refClsName.replace('/', '.')).startsWith("java")) {
                return;
            }
            if (this.clsName.equals(refClsName)) {
                return;
            }
            if (this.clsName.startsWith(refClsName) && refClsName.indexOf(36) >= 0) {
                return;
            }
            if (refClsName.startsWith(this.clsName) && this.clsName.indexOf(36) >= 0) {
                return;
            }
            if (this.isStaticChild(this.clsName, refClsName) || this.isStaticChild(refClsName, this.clsName)) {
                return;
            }
            Set<String> dependencies = this.dependencyGraph.get(this.clsName);
            if (dependencies == null) {
                dependencies = new HashSet<String>();
                this.dependencyGraph.put(this.clsName, dependencies);
            }
            dependencies.add(refClsName);
        }
    }

    public void report() {
        this.removeDependencyLeaves();
        LoopFinder lf = new LoopFinder();
        while (!this.dependencyGraph.isEmpty()) {
            boolean pruneLeaves;
            String className = this.dependencyGraph.keySet().iterator().next();
            Set<String> loop = lf.findLoop(this.dependencyGraph, className);
            if (loop != null) {
                BugInstance bug = new BugInstance((Detector)this, BugType.CD_CIRCULAR_DEPENDENCY.name(), 2);
                for (String loopCls : loop) {
                    bug.addClass(loopCls);
                }
                this.bugReporter.reportBug(bug);
                pruneLeaves = this.removeLoopLinks(loop);
            } else {
                this.dependencyGraph.remove(className);
                pruneLeaves = true;
            }
            if (!pruneLeaves) continue;
            this.removeDependencyLeaves();
        }
        this.dependencyGraph.clear();
    }

    private boolean isStaticChild(String child, String parent) {
        if (!child.startsWith(parent)) {
            return false;
        }
        String extra = child.substring(parent.length());
        return extra.charAt(0) == '.' && extra.indexOf(46, 1) < 0;
    }

    private void removeDependencyLeaves() {
        boolean changed = true;
        while (changed) {
            changed = false;
            Iterator<Set<String>> it = this.dependencyGraph.values().iterator();
            while (it.hasNext()) {
                Set<String> dependencies = it.next();
                boolean foundClass = false;
                Iterator<String> dit = dependencies.iterator();
                while (dit.hasNext()) {
                    foundClass = this.dependencyGraph.containsKey(dit.next());
                    if (foundClass) continue;
                    dit.remove();
                    changed = true;
                }
                if (!dependencies.isEmpty()) continue;
                it.remove();
                changed = true;
            }
        }
    }

    private boolean removeLoopLinks(Set<String> loop) {
        Set<String> dependencies = null;
        for (String className : loop) {
            if (dependencies != null) {
                dependencies.remove(className);
            }
            dependencies = this.dependencyGraph.get(className);
        }
        if (dependencies != null) {
            dependencies.remove(loop.iterator().next());
        }
        boolean removedClass = false;
        Iterator<String> cIt = loop.iterator();
        while (cIt.hasNext()) {
            String className = cIt.next();
            dependencies = this.dependencyGraph.get(className);
            if (!dependencies.isEmpty()) continue;
            cIt.remove();
            removedClass = true;
        }
        return removedClass;
    }

    static class LoopFinder {
        private Map<String, Set<String>> dGraph = null;
        private String startClass = null;
        private Set<String> visited = null;
        private Set<String> loop = null;

        LoopFinder() {
        }

        public Set<String> findLoop(Map<String, Set<String>> dependencyGraph, String startCls) {
            this.dGraph = dependencyGraph;
            this.startClass = startCls;
            this.visited = new HashSet<String>();
            this.loop = new LinkedHashSet<String>();
            if (this.findLoop(this.startClass)) {
                return this.loop;
            }
            return null;
        }

        private boolean findLoop(String curClass) {
            if (curClass.contains("$")) {
                return false;
            }
            Set<String> dependencies = this.dGraph.get(curClass);
            if (dependencies == null) {
                return false;
            }
            this.visited.add(curClass);
            this.loop.add(curClass);
            for (String depClass : dependencies) {
                if (depClass.equals(this.startClass)) {
                    return true;
                }
                if (this.visited.contains(depClass) || !this.findLoop(depClass)) continue;
                return true;
            }
            this.loop.remove(curClass);
            return false;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

