/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class ClassImpersonatingString
extends BytecodeScanningDetector {
    private static Map<CollectionMethod, int[]> COLLECTION_PARMS = new HashMap<CollectionMethod, int[]>();
    private static final Map<String, Integer> STRING_PARSE_METHODS;
    private static final String TO_STRING = "toString";
    private static final String FROM_FIELD = "FROM_FIELD";
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private BitSet toStringStringBuilders;

    public ClassImpersonatingString(BugReporter reporter) {
        this.bugReporter = reporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.toStringStringBuilders = new BitSet();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.toStringStringBuilders = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.toStringStringBuilders.clear();
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        int[] checkParms;
        String userValue;
        block19: {
            int n;
            int[] nArray;
            OpcodeStack.Item item;
            block18: {
                userValue = null;
                checkParms = null;
                try {
                    this.stack.precomputation((DismantleBytecode)this);
                    switch (seen) {
                        case 182: {
                            OpcodeStack.Item item2;
                            Integer priority;
                            boolean isStringBuilder;
                            String clsName = this.getClassConstantOperand();
                            String methodName = this.getNameConstantOperand();
                            String sig = this.getSigConstantOperand();
                            boolean bl = isStringBuilder = "java/lang/StringBuilder".equals(clsName) || "java/lang/StringBuffer".equals(clsName);
                            if (TO_STRING.equals(methodName) && "()Ljava/lang/String;".equals(sig)) {
                                if (isStringBuilder) {
                                    if (this.stack.getStackDepth() <= 0) break;
                                    OpcodeStack.Item item3 = this.stack.getStackItem(0);
                                    userValue = (String)item3.getUserValue();
                                    break;
                                }
                                userValue = TO_STRING;
                                break;
                            }
                            if (isStringBuilder) {
                                if ("append".equals(methodName)) {
                                    int reg;
                                    OpcodeStack.Item item4;
                                    if (this.stack.getStackDepth() <= 0 || (userValue = (String)(item4 = this.stack.getStackItem(0)).getUserValue()) != null || "Ljava/lang/String;".equals(item4.getSignature())) break;
                                    userValue = TO_STRING;
                                    if (this.stack.getStackDepth() <= 1 || (reg = (item4 = this.stack.getStackItem(1)).getRegisterNumber()) < 0) break;
                                    this.toStringStringBuilders.set(reg);
                                    break;
                                }
                                if (!"setLength".equals(methodName) || this.stack.getStackDepth() <= 1) break;
                                OpcodeStack.Item item5 = this.stack.getStackItem(1);
                                item5.setUserValue(null);
                                int reg = item5.getRegisterNumber();
                                if (reg < 0) break;
                                this.toStringStringBuilders.clear(reg);
                                break;
                            }
                            if (!"java/lang/String".equals(clsName) || (priority = STRING_PARSE_METHODS.get(methodName)) == null) break;
                            Type[] parmTypes = Type.getArgumentTypes((String)sig);
                            if (this.stack.getStackDepth() <= parmTypes.length || (item2 = this.stack.getStackItem(parmTypes.length)).getXField() == null && !FROM_FIELD.equals(item2.getUserValue())) break;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CIS_STRING_PARSING_A_FIELD.name(), priority.intValue()).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                        case 185: {
                            CollectionMethod cm;
                            String clsName = this.getClassConstantOperand();
                            String methodName = this.getNameConstantOperand();
                            String sig = this.getSigConstantOperand();
                            Type[] parmTypes = Type.getArgumentTypes((String)sig);
                            if (this.stack.getStackDepth() <= parmTypes.length || (checkParms = COLLECTION_PARMS.get(cm = new CollectionMethod(clsName, methodName, sig))) == null) break;
                            item = this.stack.getStackItem(parmTypes.length);
                            if (item.getXField() != null) {
                                nArray = checkParms;
                                n = nArray.length;
                                break block18;
                            } else {
                                checkParms = null;
                                break;
                            }
                        }
                        case 181: {
                            OpcodeStack.Item item6;
                            if (this.stack.getStackDepth() <= 0 || !TO_STRING.equals((item6 = this.stack.getStackItem(0)).getUserValue())) break;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CIS_TOSTRING_STORED_IN_FIELD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                        case 25: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: {
                            int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                            if (!this.toStringStringBuilders.get(reg)) break;
                            userValue = TO_STRING;
                            break;
                        }
                        case 58: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: {
                            int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                            this.toStringStringBuilders.clear(reg);
                            break;
                        }
                    }
                    break block19;
                }
                catch (Throwable throwable) {
                    OpcodeStack.Item item7;
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    if (userValue != null && this.stack.getStackDepth() > 0) {
                        item7 = this.stack.getStackItem(0);
                        item7.setUserValue((Object)userValue);
                    }
                    if (checkParms == null) throw throwable;
                    if (checkParms[0] != -1) throw throwable;
                    if (this.stack.getStackDepth() <= 0) throw throwable;
                    item7 = this.stack.getStackItem(0);
                    item7.setUserValue((Object)FROM_FIELD);
                    throw throwable;
                }
            }
            for (int i = 0; i < n; ++i) {
                int parm = nArray[i];
                if (parm < 0 || !TO_STRING.equals((item = this.stack.getStackItem(parm)).getUserValue())) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CIS_TOSTRING_STORED_IN_FIELD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                break;
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (userValue != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)userValue);
        }
        if (checkParms == null) return;
        if (checkParms[0] != -1) return;
        if (this.stack.getStackDepth() <= 0) return;
        OpcodeStack.Item item = this.stack.getStackItem(0);
        item.setUserValue((Object)FROM_FIELD);
    }

    static {
        int[] parm0 = new int[]{0};
        int[] parm0N1 = new int[]{-1, 0};
        int[] parm01N1 = new int[]{-1, 0, 1};
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "contains", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "add", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "remove", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "set", "(ILjava/lang/Object;)Ljava/lang/Object;"), parm0N1);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "add", "(ILjava/lang/Object;)V"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "indexOf", "(Ljava/lang/Object;)I"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/List", "lastIndexOf", "(Ljava/lang/Object;)I"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Set", "contains", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Set", "add", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Set", "remove", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Map", "containsKey", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Map", "containsValue", "(Ljava/lang/Object;)Z"), parm0);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;"), parm0N1);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), parm01N1);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;"), parm01N1);
        COLLECTION_PARMS.put(new CollectionMethod("java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;"), parm0N1);
        STRING_PARSE_METHODS = new HashMap<String, Integer>();
        STRING_PARSE_METHODS.put("indexOf", 2);
        STRING_PARSE_METHODS.put("lastIndexOf", 2);
        STRING_PARSE_METHODS.put("substring", 2);
        STRING_PARSE_METHODS.put("split", 2);
        STRING_PARSE_METHODS.put("startsWith", 3);
        STRING_PARSE_METHODS.put("endsWith", 3);
    }

    static class CollectionMethod {
        private String clsName;
        private String methodName;
        private String signature;

        public CollectionMethod(String clsN, String methodN, String sig) {
            this.clsName = clsN;
            this.methodName = methodN;
            this.signature = sig;
        }

        public int hashCode() {
            return this.clsName.hashCode() ^ this.methodName.hashCode() ^ this.signature.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof CollectionMethod)) {
                return false;
            }
            CollectionMethod that = (CollectionMethod)o;
            return this.clsName.equals(that.clsName) && this.methodName.equals(that.methodName) && this.signature.equals(that.signature);
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

