/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariableTable;

public class CommonsHashcodeBuilderToHashcode
extends BytecodeScanningDetector {
    private static final String LANG_HASH_CODE_BUILDER = "Lorg/apache/commons/lang/builder/HashCodeBuilder;";
    private static final String LANG3_HASH_CODE_BUILDER = "Lorg/apache/commons/lang3/builder/HashCodeBuilder;";
    private final OpcodeStack stack = new OpcodeStack();
    private final BugReporter bugReporter;

    public CommonsHashcodeBuilderToHashcode(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        if (lvt != null) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        String calledClass;
        String methodName;
        if (seen == 182 && "hashCode".equals(methodName = this.getNameConstantOperand()) && "()I".equals(this.getSigConstantOperand()) && this.stack.getStackDepth() > 0 && (LANG3_HASH_CODE_BUILDER.equals(calledClass = this.stack.getStackItem(0).getSignature()) || LANG_HASH_CODE_BUILDER.equals(calledClass))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CHTH_COMMONS_HASHCODE_BUILDER_TOHASHCODE", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        super.sawOpcode(seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

