/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;

public class CommonsStringBuilderToString
extends OpcodeStackDetector {
    private static final Set<String> TOSTRINGBUILDER_CTOR_SIGS = new HashSet<String>();
    private final BugReporter bugReporter;
    private final Stack<Pair> stackTracker = new Stack();
    private final Map<Integer, Boolean> registerTracker = new HashMap<Integer, Boolean>(10);

    public CommonsStringBuilderToString(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.registerTracker.clear();
        this.stackTracker.clear();
        super.visit(obj);
    }

    public boolean shouldVisitCode(Code obj) {
        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
        return lvt != null;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                Integer loadReg;
                Boolean appendInvoked;
                String signature;
                LocalVariable lv = this.getMethod().getLocalVariableTable().getLocalVariable(RegisterUtils.getALoadReg((DismantleBytecode)this, seen), this.getNextPC());
                if (lv == null || !CommonsStringBuilderToString.isToStringBuilder(signature = lv.getSignature()) || (appendInvoked = this.registerTracker.get(loadReg = Integer.valueOf(this.getRegisterOperand()))) == null) break;
                this.stackTracker.add(new Pair(loadReg, appendInvoked));
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                OpcodeStack.Item si = this.stack.getStackItem(0);
                String signature = si.getSignature();
                if (!CommonsStringBuilderToString.isToStringBuilder(signature)) break;
                int storeReg = this.getRegisterOperand();
                Pair p = this.stackTracker.pop();
                this.registerTracker.put(storeReg, p.register == -1 ? Boolean.FALSE : this.registerTracker.get(p.register));
                break;
            }
            case 87: {
                OpcodeStack.Item si = this.stack.getStackItem(0);
                String signature = si.getSignature();
                if (!CommonsStringBuilderToString.isToStringBuilder(signature) || this.stackTracker.isEmpty()) break;
                Pair p = this.stackTracker.pop();
                this.registerTracker.put(p.register, p.appendInvoked);
                break;
            }
            case 182: 
            case 183: {
                String loadClassName = this.getClassConstantOperand();
                String calledMethodName = this.getNameConstantOperand();
                if (!"org/apache/commons/lang3/builder/ToStringBuilder".equals(loadClassName) && !"org/apache/commons/lang/builder/ToStringBuilder".equals(loadClassName)) break;
                String calledMethodSig = this.getSigConstantOperand();
                if ("<init>".equals(calledMethodName) && TOSTRINGBUILDER_CTOR_SIGS.contains(calledMethodSig)) {
                    this.stackTracker.add(new Pair(-1, false));
                    break;
                }
                if ("append".equals(calledMethodName)) {
                    Pair p = this.stackTracker.pop();
                    this.stackTracker.add(new Pair(p.register, true));
                    break;
                }
                if (!"toString".equals(calledMethodName) || !"()Ljava/lang/String;".equals(calledMethodSig)) break;
                Pair p = this.stackTracker.pop();
                if (p.appendInvoked) break;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "CSBTS_COMMONS_STRING_BUILDER_TOSTRING", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                break;
            }
        }
    }

    private static boolean isToStringBuilder(String signature) {
        return "Lorg/apache/commons/lang3/builder/ToStringBuilder;".equals(signature) || "Lorg/apache/commons/lang/builder/ToStringBuilder;".equals(signature);
    }

    static {
        TOSTRINGBUILDER_CTOR_SIGS.add("(Ljava/lang/Object;)V");
        TOSTRINGBUILDER_CTOR_SIGS.add("(Ljava/lang/Object;Lorg/apache/commons/lang/builder/ToStringStyle;)V");
        TOSTRINGBUILDER_CTOR_SIGS.add("(Ljava/lang/Object;Lorg/apache/commons/lang3/builder/ToStringStyle;)V");
    }

    static final class Pair {
        public final int register;
        public final boolean appendInvoked;

        Pair(int register, boolean appendInvoked) {
            this.register = register;
            this.appendInvoked = appendInvoked;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

