/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class ConflictingTimeUnits
extends BytecodeScanningDetector {
    private static Map<String, Units> TIME_UNIT_GENERATING_METHODS = new HashMap<String, Units>();
    private static Map<String, Units> TIMEUNIT_TO_UNITS;
    private BugReporter bugReporter;
    private OpcodeStack stack;

    public ConflictingTimeUnits(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        Units unit = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 184: 
                case 185: {
                    String methodCall = this.getClassConstantOperand() + "." + this.getNameConstantOperand() + this.getSigConstantOperand();
                    unit = TIME_UNIT_GENERATING_METHODS.get(methodCall);
                    if (unit != Units.CALLER) return;
                    int offset = Type.getArgumentTypes((String)this.getSigConstantOperand()).length;
                    if (this.stack.getStackDepth() > offset) {
                        OpcodeStack.Item item = this.stack.getStackItem(offset);
                        unit = (Units)((Object)item.getUserValue());
                        return;
                    }
                    unit = null;
                    return;
                }
                case 178: {
                    String clsName = this.getClassConstantOperand();
                    if (!"java/util/concurrent/TimeUnit".equals(clsName)) {
                        if (!"edu/emory/matchcs/backport/java/util/concurrent/TimeUnit".equals(clsName)) return;
                    }
                    unit = TIMEUNIT_TO_UNITS.get(this.getNameConstantOperand());
                    return;
                }
                case 133: 
                case 136: {
                    if (this.stack.getStackDepth() <= 0) return;
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    unit = (Units)((Object)item.getUserValue());
                    return;
                }
                case 96: 
                case 97: 
                case 100: 
                case 101: 
                case 104: 
                case 105: 
                case 108: 
                case 109: 
                case 112: 
                case 113: {
                    if (this.stack.getStackDepth() <= 1) return;
                    OpcodeStack.Item arg1 = this.stack.getStackItem(0);
                    OpcodeStack.Item arg2 = this.stack.getStackItem(1);
                    Units u1 = (Units)((Object)arg1.getUserValue());
                    Units u2 = (Units)((Object)arg2.getUserValue());
                    if (u1 == null) return;
                    if (u2 == null) return;
                    if (u1 == u2) return;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CTU_CONFLICTING_TIME_UNITS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(u1.toString()).addString(u2.toString()));
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (unit != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)unit);
            }
        }
    }

    static {
        TIME_UNIT_GENERATING_METHODS.put("java/lang/System.currentTimeMillis()J", Units.MILLIS);
        TIME_UNIT_GENERATING_METHODS.put("java/lang/System.nanoTime()J", Units.NANOS);
        TIME_UNIT_GENERATING_METHODS.put("java/sql/Timestamp.getTime()J", Units.MILLIS);
        TIME_UNIT_GENERATING_METHODS.put("java/sql/Timestamp.getNanos()I", Units.NANOS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/Date.getTime()J", Units.MILLIS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.toNanos(J)J", Units.NANOS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.toMicros(J)J", Units.MICROS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.toSeconds(J)J", Units.SECONDS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.toMinutes(J)J", Units.MINUTES);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.toHours(J)J", Units.HOURS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.toDays(J)J", Units.DAYS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.excessNanos(JJ)I", Units.NANOS);
        TIME_UNIT_GENERATING_METHODS.put("java/util/concurrent/TimeUnit.convert(JLjava/util/concurrent/TimeUnit;)J", Units.CALLER);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.toNanos(J)J", Units.NANOS);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.toMicros(J)J", Units.MICROS);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.toSeconds(J)J", Units.SECONDS);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.toMinutes(J)J", Units.MINUTES);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.toHours(J)J", Units.HOURS);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.toDays(J)J", Units.DAYS);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.excessNanos(JJ)I", Units.NANOS);
        TIME_UNIT_GENERATING_METHODS.put("edu/emory/matchcs/backport/java/util/concurrent/TimeUnit.convert(JLjava/util/concurrent/TimeUnit;)J", Units.CALLER);
        TIME_UNIT_GENERATING_METHODS.put("org/joda/time/base/BaseDuration.getMillis()J", Units.MILLIS);
        TIME_UNIT_GENERATING_METHODS.put("org/joda/time/base/BaseInterval.getEndMillis()J", Units.MILLIS);
        TIME_UNIT_GENERATING_METHODS.put("org/joda/time/base/BaseInterval.getStartMillis()J", Units.MILLIS);
        TIMEUNIT_TO_UNITS = new HashMap<String, Units>();
        TIMEUNIT_TO_UNITS.put("NANOSECONDS", Units.NANOS);
        TIMEUNIT_TO_UNITS.put("MICROSECONDS", Units.MICROS);
        TIMEUNIT_TO_UNITS.put("MILLISECONDS", Units.MILLIS);
        TIMEUNIT_TO_UNITS.put("SECONDS", Units.SECONDS);
        TIMEUNIT_TO_UNITS.put("MINUTES", Units.MINUTES);
        TIMEUNIT_TO_UNITS.put("HOURS", Units.HOURS);
        TIMEUNIT_TO_UNITS.put("DAYS", Units.DAYS);
    }

    private static enum Units {
        NANOS,
        MICROS,
        MILLIS,
        SECONDS,
        MINUTES,
        HOURS,
        DAYS,
        CALLER;

    }
}

