/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class ConfusingFunctionSemantics
extends BytecodeScanningDetector {
    private static final Set<String> knownImmutables = new HashSet<String>(10);
    private final BugReporter bugReporter;
    private Map<Integer, ParmUsage> possibleParmRegs;
    private OpcodeStack stack;

    public ConfusingFunctionSemantics(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.possibleParmRegs = new HashMap<Integer, ParmUsage>(10);
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.possibleParmRegs = null;
        }
    }

    public void visitCode(Code obj) {
        try {
            this.possibleParmRegs.clear();
            Method m = this.getMethod();
            String methodSignature = m.getSignature();
            String retSignature = Type.getReturnType((String)methodSignature).getSignature();
            JavaClass returnClass = null;
            int[] parmRegs = null;
            if (retSignature.charAt(0) == 'L' && !knownImmutables.contains(retSignature)) {
                Type[] parmTypes = Type.getArgumentTypes((String)methodSignature);
                for (int p = 0; p < parmTypes.length; ++p) {
                    String parmSignature = parmTypes[p].getSignature();
                    if (parmSignature.charAt(0) != 'L' || knownImmutables.contains(parmSignature)) continue;
                    if (returnClass == null) {
                        returnClass = Repository.lookupClass((String)retSignature.substring(1, retSignature.length() - 1));
                        parmRegs = RegisterUtils.getParameterRegisters(m);
                    }
                    JavaClass parmClass = Repository.lookupClass((String)parmSignature.substring(1, parmSignature.length() - 1));
                    if (parmRegs == null || !parmClass.instanceOf(returnClass)) continue;
                    this.possibleParmRegs.put(parmRegs[p], new ParmUsage());
                }
                if (this.possibleParmRegs.size() > 0) {
                    this.stack.resetForMethodEntry((DismantleBytecode)this);
                    super.visitCode(obj);
                    for (ParmUsage pu : this.possibleParmRegs.values()) {
                        if (pu.returnPC < 0 || pu.alteredPC < 0) continue;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.CFS_CONFUSING_FUNCTION_SEMANTICS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pu.returnPC).addSourceLine((BytecodeScanningDetector)this, pu.alteredPC));
                    }
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        if (this.possibleParmRegs.isEmpty()) {
            return;
        }
        try {
            String calledSig;
            String calledRet;
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 176) {
                OpcodeStack.Item item;
                int reg;
                ParmUsage pu;
                if (this.stack.getStackDepth() > 0 && (pu = this.possibleParmRegs.get(reg = (item = this.stack.getStackItem(0)).getRegisterNumber())) != null) {
                    pu.setReturnPC(this.getPC());
                }
            } else if (seen == 181) {
                OpcodeStack.Item item;
                int reg;
                ParmUsage pu;
                if (this.stack.getStackDepth() > 1 && (pu = this.possibleParmRegs.get(reg = (item = this.stack.getStackItem(1)).getRegisterNumber())) != null) {
                    pu.setAlteredPC(this.getPC());
                }
            } else if (OpcodeUtils.isAStore(seen)) {
                int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                this.possibleParmRegs.remove(reg);
            } else if ((seen == 182 || seen == 185) && "V".equals(calledRet = Type.getReturnType((String)(calledSig = this.getSigConstantOperand())).getSignature())) {
                OpcodeStack.Item item;
                int reg;
                ParmUsage pu;
                int calledObjOffset = Type.getArgumentTypes((String)calledSig).length;
                if (this.stack.getStackDepth() > calledObjOffset && (pu = this.possibleParmRegs.get(reg = (item = this.stack.getStackItem(calledObjOffset)).getRegisterNumber())) != null) {
                    pu.setAlteredPC(this.getPC());
                }
            }
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    static {
        knownImmutables.add("Ljava/lang/String;");
        knownImmutables.add("Ljava/lang/Byte;");
        knownImmutables.add("Ljava/lang/Character;");
        knownImmutables.add("Ljava/lang/Short;");
        knownImmutables.add("Ljava/lang/Integer;");
        knownImmutables.add("Ljava/lang/Long;");
        knownImmutables.add("Ljava/lang/Float;");
        knownImmutables.add("Ljava/lang/Double;");
        knownImmutables.add("Ljava/lang/Boolean;");
        knownImmutables.add("Ljava/lang/Class;");
    }

    static class ParmUsage {
        int returnPC = -1;
        int alteredPC = -1;

        ParmUsage() {
        }

        void setReturnPC(int pc) {
            this.returnPC = pc;
        }

        void setAlteredPC(int pc) {
            if (this.alteredPC < 0) {
                this.alteredPC = pc;
            }
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

