/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class CopiedOverriddenMethod
extends DismantleBytecode
implements Detector {
    private final BugReporter bugReporter;
    private Map<String, Code> superclassCode;
    private ClassContext classContext;
    private String curMethodInfo;
    private ConstantPoolGen childPoolGen;
    private ConstantPoolGen parentPoolGen;

    public CopiedOverriddenMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext clsContext) {
        try {
            JavaClass cls = clsContext.getJavaClass();
            String superName = cls.getSuperclassName();
            if (!"java.lang.Object".equals(superName)) {
                Method[] methods;
                this.classContext = clsContext;
                this.superclassCode = new HashMap<String, Code>();
                JavaClass superCls = cls.getSuperClass();
                this.childPoolGen = new ConstantPoolGen(cls.getConstantPool());
                this.parentPoolGen = new ConstantPoolGen(superCls.getConstantPool());
                for (Method m : methods = superCls.getMethods()) {
                    String methodName = m.getName();
                    if (!m.isPublic() && !m.isProtected() || m.isAbstract() || "<init>".equals(methodName) || "<clinit>".equals(methodName)) continue;
                    String methodInfo = methodName + ":" + m.getSignature();
                    this.superclassCode.put(methodInfo, m.getCode());
                }
                cls.accept((Visitor)this);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.superclassCode = null;
            this.classContext = null;
            this.childPoolGen = null;
            this.parentPoolGen = null;
        }
    }

    public void visitMethod(Method obj) {
        this.curMethodInfo = obj.getName() + ":" + obj.getSignature();
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        if (!(m.isPublic() || m.isProtected() || m.isAbstract())) {
            return;
        }
        Code superCode = this.superclassCode.get(this.curMethodInfo);
        if (superCode != null && this.codeEquals(obj, superCode)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.COM_COPIED_OVERRIDDEN_METHOD.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine(this.classContext, (PreorderVisitor)this, this.getPC()));
        }
    }

    private boolean codeEquals(Code child, Code parent) {
        InstructionHandle[] parentihs;
        byte[] childBytes = child.getCode();
        byte[] parentBytes = parent.getCode();
        if (childBytes == null || parentBytes == null) {
            return false;
        }
        if (childBytes.length != parentBytes.length) {
            return false;
        }
        InstructionHandle[] childihs = new InstructionList(childBytes).getInstructionHandles();
        if (childihs.length != (parentihs = new InstructionList(parentBytes).getInstructionHandles()).length) {
            return false;
        }
        for (int i = 0; i < childihs.length; ++i) {
            InstructionHandle childih = childihs[i];
            InstructionHandle parentih = parentihs[i];
            Instruction childin = childih.getInstruction();
            Instruction parentin = parentih.getInstruction();
            if (!childin.getName().equals(parentin.getName())) {
                return false;
            }
            if (childin instanceof FieldInstruction) {
                String parentFSig;
                String parentFName;
                String childFName = ((FieldInstruction)childin).getFieldName(this.childPoolGen);
                if (!childFName.equals(parentFName = ((FieldInstruction)parentin).getFieldName(this.parentPoolGen))) {
                    return false;
                }
                String childFSig = ((FieldInstruction)childin).getSignature(this.childPoolGen);
                if (!childFSig.equals(parentFSig = ((FieldInstruction)parentin).getSignature(this.parentPoolGen))) {
                    return false;
                }
                if (childFSig.charAt(0) != 'L') continue;
                ReferenceType childRefType = ((FieldInstruction)childin).getReferenceType(this.childPoolGen);
                ReferenceType parentRefType = ((FieldInstruction)parentin).getReferenceType(this.parentPoolGen);
                if (childRefType.getSignature().equals(parentRefType.getSignature())) continue;
                return false;
            }
            if (childin instanceof InvokeInstruction) {
                String parentSignature;
                String parentMethodName;
                String parentClassName;
                String childClassName = ((InvokeInstruction)childin).getClassName(this.childPoolGen);
                if (!childClassName.equals(parentClassName = ((InvokeInstruction)parentin).getClassName(this.parentPoolGen))) {
                    return false;
                }
                String childMethodName = ((InvokeInstruction)childin).getMethodName(this.childPoolGen);
                if (!childMethodName.equals(parentMethodName = ((InvokeInstruction)parentin).getMethodName(this.parentPoolGen))) {
                    return false;
                }
                String childSignature = ((InvokeInstruction)childin).getSignature(this.childPoolGen);
                if (childSignature.equals(parentSignature = ((InvokeInstruction)parentin).getSignature(this.parentPoolGen))) continue;
                return false;
            }
            if (childin instanceof LDC) {
                Type parentType;
                Type childType = ((LDC)childin).getType(this.childPoolGen);
                if (!childType.equals((Object)(parentType = ((LDC)parentin).getType(this.parentPoolGen)))) {
                    return false;
                }
                Object childValue = ((LDC)childin).getValue(this.childPoolGen);
                Object parentValue = ((LDC)parentin).getValue(this.parentPoolGen);
                if (childValue instanceof ConstantClass) {
                    ConstantClass childClass = (ConstantClass)childValue;
                    ConstantClass parentClass = (ConstantClass)parentValue;
                    if (childClass.getBytes(this.childPoolGen.getConstantPool()).equals(parentClass.getBytes(this.parentPoolGen.getConstantPool()))) continue;
                    return false;
                }
                if (childValue.equals(parentValue)) continue;
                return false;
            }
            if (childin.equals((Object)parentin)) continue;
            return false;
        }
        return true;
    }

    public void report() {
    }
}

