/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Code;

public class CustomBuiltXML
extends BytecodeScanningDetector {
    private static final Map<Pattern, Boolean> xmlPatterns = new HashMap<Pattern, Boolean>(10);
    private static final String CBX_MIN_REPORTABLE_ITEMS = "fb-contrib.cbx.minxmlitems";
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private int xmlItemCount = 0;
    private int xmlConfidentCount = 0;
    private int lowReportingThreshold;
    private int midReportingThreshold;
    private int highReportingThreshold;
    private int firstPC;

    public CustomBuiltXML(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.lowReportingThreshold = Integer.getInteger(CBX_MIN_REPORTABLE_ITEMS, 5);
        this.midReportingThreshold = this.lowReportingThreshold << 1;
        this.highReportingThreshold = this.lowReportingThreshold << 2;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.xmlItemCount = 0;
        this.xmlConfidentCount = 0;
        this.firstPC = -1;
        super.visitCode(obj);
        if (this.xmlItemCount >= this.lowReportingThreshold && this.xmlConfidentCount > this.lowReportingThreshold >> 1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "CBX_CUSTOM_BUILT_XML", this.xmlItemCount >= this.highReportingThreshold ? 1 : (this.xmlItemCount >= this.midReportingThreshold ? 2 : 3)).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, this.firstPC));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block14: {
            String strCon = null;
            try {
                OpcodeStack.Item itm;
                String methodSig;
                String methodName;
                String clsName;
                this.stack.precomputation((DismantleBytecode)this);
                if (seen == 183) {
                    clsName = this.getClassConstantOperand();
                    if ("java/lang/StringBuffer".equals(clsName) || "java/lang/StringBuilder".equals(clsName)) {
                        methodName = this.getNameConstantOperand();
                        methodSig = this.getSigConstantOperand();
                        if ("<init>".equals(methodName) && ("(Ljava/lang/String;)L" + clsName + ";").equals(methodSig) && this.stack.getStackDepth() > 0) {
                            itm = this.stack.getStackItem(0);
                            strCon = (String)itm.getConstant();
                        }
                    }
                } else if (seen == 182 && ("java/lang/StringBuffer".equals(clsName = this.getClassConstantOperand()) || "java/lang/StringBuilder".equals(clsName))) {
                    methodName = this.getNameConstantOperand();
                    methodSig = this.getSigConstantOperand();
                    if ("append".equals(methodName) && ("(Ljava/lang/String;)L" + clsName + ";").equals(methodSig) && this.stack.getStackDepth() > 0) {
                        itm = this.stack.getStackItem(0);
                        strCon = (String)itm.getConstant();
                    }
                }
                if (strCon == null) break block14;
                if ((strCon = strCon.trim()).length() == 0) {
                    return;
                }
                for (Map.Entry<Pattern, Boolean> entry : xmlPatterns.entrySet()) {
                    Matcher m = entry.getKey().matcher(strCon);
                    if (!m.matches()) continue;
                    ++this.xmlItemCount;
                    if (entry.getValue().booleanValue()) {
                        ++this.xmlConfidentCount;
                    }
                    if (this.firstPC < 0 && this.xmlConfidentCount > 0) {
                        this.firstPC = this.getPC();
                    }
                    break;
                }
            }
            finally {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
            }
        }
    }

    static {
        xmlPatterns.put(Pattern.compile(".*<[a-zA-Z_](\\w)*>[^=]?.*"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*</[a-zA-Z_](\\w)*>[^=]?.*"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*<[a-zA-Z_](\\w)*/>[^=]?.*"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*<[^=]?(/)?$"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile("^(/)?>.*"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*=(\\s)*[\"'].*"), Boolean.FALSE);
        xmlPatterns.put(Pattern.compile("^[\"']>.*"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*<!\\[CDATA\\[.*", 2), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*\\]\\]>.*"), Boolean.TRUE);
        xmlPatterns.put(Pattern.compile(".*xmlns:.*"), Boolean.TRUE);
    }
}

