/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.classfile.Method;

public class DateComparison
extends BytecodeScanningDetector {
    private static final Set<String> dateClasses = new HashSet<String>(3);
    private final BugReporter bugReporter;
    private State state;
    private int register1_1;
    private int register1_2;
    private int register2_1;
    private int register2_2;

    public DateComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        this.state = State.SAW_NOTHING;
        this.register1_1 = -1;
        this.register1_2 = -1;
        this.register2_1 = -1;
        this.register2_2 = -1;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case SAW_NOTHING: {
                if (!OpcodeUtils.isALoad(seen)) break;
                this.register1_1 = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                this.state = State.SAW_LOAD1_1;
                break;
            }
            case SAW_LOAD1_1: {
                if (OpcodeUtils.isALoad(seen)) {
                    this.register1_2 = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                }
                if (this.register1_2 > -1) {
                    this.state = State.SAW_LOAD1_2;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_LOAD1_2: {
                String methodName;
                String cls;
                if (seen == 182 && dateClasses.contains(cls = this.getDottedClassConstantOperand()) && ("equals".equals(methodName = this.getNameConstantOperand()) || "after".equals(methodName) || "before".equals(methodName))) {
                    this.state = State.SAW_CMP1;
                }
                if (this.state == State.SAW_CMP1) break;
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_CMP1: {
                if (seen == 154) {
                    this.state = State.SAW_IFNE;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_IFNE: {
                if (OpcodeUtils.isALoad(seen)) {
                    this.register2_1 = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                }
                if (this.register2_1 > -1) {
                    this.state = State.SAW_LOAD2_1;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_LOAD2_1: {
                if (OpcodeUtils.isALoad(seen)) {
                    this.register2_2 = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                }
                if (this.register2_2 > -1 && (this.register1_1 == this.register2_1 && this.register1_2 == this.register2_2 || this.register1_1 == this.register2_2 && this.register1_2 == this.register2_1)) {
                    this.state = State.SAW_LOAD2_2;
                    break;
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_LOAD2_2: {
                String methodName;
                String cls;
                if (seen == 182 && dateClasses.contains(cls = this.getDottedClassConstantOperand()) && ("equals".equals(methodName = this.getNameConstantOperand()) || "after".equals(methodName) || "before".equals(methodName))) {
                    this.state = State.SAW_CMP2;
                }
                if (this.state == State.SAW_CMP2) break;
                this.state = State.SAW_NOTHING;
                break;
            }
            case SAW_CMP2: {
                if (seen == 153) {
                    this.bugReporter.reportBug(new BugInstance("DDC_DOUBLE_DATE_COMPARISON", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.state = State.SAW_NOTHING;
            }
        }
    }

    static {
        dateClasses.add("java.util.Date");
        dateClasses.add("java.sql.Date");
        dateClasses.add("java.sql.Timestamp");
    }

    static enum State {
        SAW_NOTHING,
        SAW_LOAD1_1,
        SAW_LOAD1_2,
        SAW_CMP1,
        SAW_IFNE,
        SAW_LOAD2_1,
        SAW_LOAD2_2,
        SAW_CMP2;

    }
}

