/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class DeclaredRuntimeException
extends PreorderVisitor
implements Detector {
    private final BugReporter bugReporter;
    private static JavaClass runtimeExceptionClass;
    private final Set<String> runtimeExceptions = new HashSet<String>();

    public DeclaredRuntimeException(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.runtimeExceptions.add("java.lang.RuntimeException");
    }

    public void visitClassContext(ClassContext classContext) {
        if (runtimeExceptionClass != null) {
            classContext.getJavaClass().accept((Visitor)this);
        }
    }

    public void visitMethod(Method obj) {
        ExceptionTable et = obj.getExceptionTable();
        if (et != null) {
            String[] exNames = et.getExceptionNames();
            HashSet<String> methodRTExceptions = new HashSet<String>(6);
            int priority = 3;
            boolean foundRuntime = false;
            for (String ex : exNames) {
                boolean isRuntime = false;
                if (this.runtimeExceptions.contains(ex)) {
                    isRuntime = true;
                } else {
                    try {
                        JavaClass exClass = Repository.lookupClass((String)ex);
                        if (exClass.instanceOf(runtimeExceptionClass)) {
                            this.runtimeExceptions.add(ex);
                            if (ex.startsWith("java.lang.")) {
                                priority = 2;
                            }
                            isRuntime = true;
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                }
                if (!isRuntime) continue;
                foundRuntime = true;
                methodRTExceptions.add(ex);
            }
            if (foundRuntime) {
                BugInstance bug = new BugInstance((Detector)this, BugType.DRE_DECLARED_RUNTIME_EXCEPTION.name(), priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                for (String ex : methodRTExceptions) {
                    bug.add((BugAnnotation)new StringAnnotation(ex));
                }
                this.bugReporter.reportBug(bug);
            }
        }
    }

    public void report() {
    }

    static {
        try {
            runtimeExceptionClass = Repository.lookupClass((String)"java/lang/RuntimeException");
        }
        catch (ClassNotFoundException cnfe) {
            runtimeExceptionClass = null;
        }
    }
}

