/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.graph.AbstractVertex;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;

public class FieldCouldBeLocal
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private ClassContext clsContext;
    private Map<String, FieldInfo> localizableFields;
    private CFG cfg;
    private ConstantPoolGen cpg;
    private BitSet visitedBlocks;
    private Map<String, Set<String>> methodFieldModifiers;
    private String clsName;
    private String clsSig;

    public FieldCouldBeLocal(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.localizableFields = new HashMap<String, FieldInfo>();
            this.visitedBlocks = new BitSet();
            this.clsContext = classContext;
            this.clsName = this.clsContext.getJavaClass().getClassName();
            this.clsSig = "L" + this.clsName.replace('.', '/') + ";";
            JavaClass cls = classContext.getJavaClass();
            Field[] fields = cls.getFields();
            ConstantPool cp = classContext.getConstantPoolGen().getConstantPool();
            for (Field f : fields) {
                if (f.isStatic() || f.isVolatile() || f.getName().indexOf(36) >= 0 || !f.isPrivate()) continue;
                FieldAnnotation fa = new FieldAnnotation(cls.getClassName(), f.getName(), f.getSignature(), false);
                boolean hasExternalAnnotation = false;
                for (AnnotationEntry entry : f.getAnnotationEntries()) {
                    ConstantUtf8 cutf = (ConstantUtf8)cp.getConstant(entry.getTypeIndex());
                    if (cutf.getBytes().startsWith("java")) continue;
                    hasExternalAnnotation = true;
                    break;
                }
                this.localizableFields.put(f.getName(), new FieldInfo(fa, hasExternalAnnotation));
            }
            if (this.localizableFields.size() > 0) {
                this.buildMethodFieldModifiers(classContext);
                super.visitClassContext(classContext);
                for (FieldInfo fi : this.localizableFields.values()) {
                    FieldAnnotation fa = fi.getFieldAnnotation();
                    SourceLineAnnotation sla = fi.getSrcLineAnnotation();
                    BugInstance bug = new BugInstance((Detector)this, BugType.FCBL_FIELD_COULD_BE_LOCAL.name(), 2).addClass((PreorderVisitor)this).addField(fa);
                    if (sla != null) {
                        bug.addSourceLine(sla);
                    }
                    this.bugReporter.reportBug(bug);
                }
            }
        }
        finally {
            this.localizableFields = null;
            this.visitedBlocks = null;
            this.clsContext = null;
            this.methodFieldModifiers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMethod(Method obj) {
        if (this.localizableFields.isEmpty()) {
            return;
        }
        try {
            this.cfg = this.clsContext.getCFG(obj);
            this.cpg = this.cfg.getMethodGen().getConstantPool();
            BasicBlock bb = this.cfg.getEntry();
            HashSet<String> uncheckedFields = new HashSet<String>(this.localizableFields.keySet());
            this.visitedBlocks.clear();
            this.checkBlock(bb, uncheckedFields);
        }
        catch (CFGBuilderException cbe) {
            this.localizableFields.clear();
        }
        finally {
            this.cfg = null;
            this.cpg = null;
        }
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(181) || bytecodeSet.get(180));
    }

    public void visitCode(Code obj) {
        String methodName;
        Method m = this.getMethod();
        if (this.prescreen(m) && ("<clinit".equals(methodName = m.getName()) || "<init>".equals(methodName))) {
            super.visitCode(obj);
        }
    }

    public void sawOpcode(int seen) {
        String fieldName;
        FieldInfo fi;
        if ((seen == 180 || seen == 181) && (fi = this.localizableFields.get(fieldName = this.getNameConstantOperand())) != null) {
            SourceLineAnnotation sla = SourceLineAnnotation.fromVisitedInstruction((BytecodeScanningDetector)this);
            fi.setSrcLineAnnotation(sla);
        }
    }

    private void checkBlock(BasicBlock bb, Set<String> uncheckedFields) {
        LinkedList<BlockState> toBeProcessed = new LinkedList<BlockState>();
        toBeProcessed.add(new BlockState(bb, uncheckedFields));
        this.visitedBlocks.set(bb.getLabel());
        while (!toBeProcessed.isEmpty()) {
            if (this.localizableFields.isEmpty()) {
                return;
            }
            BlockState bState = (BlockState)toBeProcessed.removeFirst();
            bb = bState.getBasicBlock();
            BasicBlock.InstructionIterator ii = bb.instructionIterator();
            while (bState.getUncheckedFieldSize() > 0 && ii.hasNext()) {
                String methodDesc;
                Set<String> fields;
                INVOKESPECIAL is;
                InstructionHandle ih = ii.next();
                Instruction ins = ih.getInstruction();
                if (ins instanceof FieldInstruction) {
                    FieldInstruction fi = (FieldInstruction)ins;
                    if (!fi.getReferenceType(this.cpg).getSignature().equals(this.clsSig)) continue;
                    String fieldName = fi.getFieldName(this.cpg);
                    FieldInfo finfo = this.localizableFields.get(fieldName);
                    if (finfo != null && this.localizableFields.get(fieldName).hasAnnotation()) {
                        this.localizableFields.remove(fieldName);
                        continue;
                    }
                    boolean justRemoved = bState.removeUncheckedField(fieldName);
                    if (ins instanceof GETFIELD) {
                        if (!justRemoved) continue;
                        this.localizableFields.remove(fieldName);
                        if (!this.localizableFields.isEmpty()) continue;
                        return;
                    }
                    if (finfo == null) continue;
                    finfo.setSrcLineAnnotation(SourceLineAnnotation.fromVisitedInstruction((ClassContext)this.clsContext, (PreorderVisitor)this, (int)ih.getPosition()));
                    continue;
                }
                if (ins instanceof INVOKESPECIAL) {
                    is = (INVOKESPECIAL)ins;
                    if (!"<init>".equals(is.getMethodName(this.cpg)) || !is.getClassName(this.cpg).startsWith(this.clsContext.getJavaClass().getClassName() + "$")) continue;
                    this.localizableFields.clear();
                    continue;
                }
                if (!(ins instanceof INVOKEVIRTUAL) || !(is = (INVOKEVIRTUAL)ins).getClassName(this.cpg).equals(this.clsName) || (fields = this.methodFieldModifiers.get(methodDesc = is.getName(this.cpg) + is.getSignature(this.cpg))) == null) continue;
                for (String field : fields) {
                    this.localizableFields.remove(field);
                }
            }
            if (bState.getUncheckedFieldSize() <= 0) continue;
            Iterator oei = this.cfg.outgoingEdgeIterator((AbstractVertex)bb);
            while (oei.hasNext()) {
                Edge e = (Edge)oei.next();
                BasicBlock cb = (BasicBlock)e.getTarget();
                int label = cb.getLabel();
                if (this.visitedBlocks.get(label)) continue;
                toBeProcessed.addLast(new BlockState(cb, bState));
                this.visitedBlocks.set(label);
            }
        }
    }

    private void buildMethodFieldModifiers(ClassContext classContext) {
        FieldModifier fm = new FieldModifier();
        fm.visitClassContext(classContext);
        this.methodFieldModifiers = fm.getMethodFieldModifiers();
    }

    private static class FieldModifier
    extends BytecodeScanningDetector {
        private final Map<String, Set<String>> methodCallChain = new HashMap<String, Set<String>>();
        private final Map<String, Set<String>> mfModifiers = new HashMap<String, Set<String>>();
        private String clsName;

        private FieldModifier() {
        }

        public Map<String, Set<String>> getMethodFieldModifiers() {
            HashMap<String, Set<String>> modifiers = new HashMap<String, Set<String>>(this.mfModifiers.size());
            modifiers.putAll(this.mfModifiers);
            for (Map.Entry method : modifiers.entrySet()) {
                modifiers.put((String)method.getKey(), new HashSet((Collection)method.getValue()));
            }
            boolean modified = true;
            while (modified) {
                modified = false;
                for (Map.Entry<String, Set<String>> entry : this.methodCallChain.entrySet()) {
                    String methodDesc = entry.getKey();
                    Set<String> calledMethods = entry.getValue();
                    for (String calledMethodDesc : calledMethods) {
                        Set<String> fields = this.mfModifiers.get(calledMethodDesc);
                        if (fields == null) continue;
                        HashSet<String> flds = (HashSet<String>)modifiers.get(methodDesc);
                        if (flds == null) {
                            flds = new HashSet<String>();
                            modifiers.put(methodDesc, flds);
                        }
                        if (!flds.addAll(fields)) continue;
                        modified = true;
                    }
                }
            }
            return modifiers;
        }

        public void visitClassContext(ClassContext context) {
            this.clsName = context.getJavaClass().getClassName();
            super.visitClassContext(context);
        }

        public void sawOpcode(int seen) {
            if (seen == 181) {
                if (this.clsName.equals(this.getClassConstantOperand())) {
                    String methodDesc = this.getMethodName() + this.getMethodSig();
                    Set<String> fields = this.mfModifiers.get(methodDesc);
                    if (fields == null) {
                        fields = new HashSet<String>();
                        this.mfModifiers.put(methodDesc, fields);
                    }
                    fields.add(this.getNameConstantOperand());
                }
            } else if (seen == 182 && this.clsName.equals(this.getClassConstantOperand())) {
                String methodDesc = this.getMethodName() + this.getMethodSig();
                Set<String> methods = this.methodCallChain.get(methodDesc);
                if (methods == null) {
                    methods = new HashSet<String>();
                    this.methodCallChain.put(methodDesc, methods);
                }
                methods.add(this.getNameConstantOperand() + this.getSigConstantOperand());
            }
        }

        public String toString() {
            return ToString.build((Object)this);
        }
    }

    private static class BlockState {
        private final BasicBlock basicBlock;
        private Set<String> uncheckedFields;
        private boolean fieldsAreSharedWithParent;

        public BlockState(BasicBlock bb, Set<String> fields) {
            this.basicBlock = bb;
            this.uncheckedFields = fields;
            this.fieldsAreSharedWithParent = true;
        }

        public BlockState(BasicBlock bb, BlockState parentBlockState) {
            this.basicBlock = bb;
            this.uncheckedFields = parentBlockState.uncheckedFields;
            this.fieldsAreSharedWithParent = true;
        }

        public BasicBlock getBasicBlock() {
            return this.basicBlock;
        }

        public int getUncheckedFieldSize() {
            return this.uncheckedFields == null ? 0 : this.uncheckedFields.size();
        }

        public boolean removeUncheckedField(String field) {
            if (this.uncheckedFields != null && this.uncheckedFields.contains(field)) {
                if (this.uncheckedFields.size() == 1) {
                    this.uncheckedFields = null;
                    this.fieldsAreSharedWithParent = false;
                    return true;
                }
                if (this.fieldsAreSharedWithParent) {
                    this.uncheckedFields = new HashSet<String>(this.uncheckedFields);
                    this.fieldsAreSharedWithParent = false;
                    this.uncheckedFields.remove(field);
                } else {
                    this.uncheckedFields.remove(field);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return ToString.build(this);
        }
    }

    private static class FieldInfo {
        private final FieldAnnotation fieldAnnotation;
        private SourceLineAnnotation srcLineAnnotation;
        private final boolean hasAnnotation;

        FieldInfo(FieldAnnotation fa, boolean hasExternalAnnotation) {
            this.fieldAnnotation = fa;
            this.srcLineAnnotation = null;
            this.hasAnnotation = hasExternalAnnotation;
        }

        void setSrcLineAnnotation(SourceLineAnnotation sla) {
            if (this.srcLineAnnotation == null) {
                this.srcLineAnnotation = sla;
            }
        }

        FieldAnnotation getFieldAnnotation() {
            return this.fieldAnnotation;
        }

        SourceLineAnnotation getSrcLineAnnotation() {
            return this.srcLineAnnotation;
        }

        boolean hasAnnotation() {
            return this.hasAnnotation;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

