/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class FinalParameters
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private BitSet changedParms;
    private String methodName;
    private int firstLocalReg;
    private boolean isAbstract;
    private boolean srcInited;
    private SourceLineAnnotation srcLineAnnotation;
    private String[] sourceLines;

    public FinalParameters(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.srcInited = false;
        super.visitClassContext(classContext);
    }

    public void visitMethod(Method obj) {
        this.methodName = obj.getName();
        if ("<clinit>".equals(this.methodName) || "<init>".equals(this.methodName)) {
            return;
        }
        Type[] parms = Type.getArgumentTypes((String)obj.getSignature());
        if (parms.length > 0) {
            boolean isStatic = (obj.getAccessFlags() & 8) != 0;
            this.isAbstract = (obj.getAccessFlags() & 0x400) != 0;
            this.firstLocalReg = isStatic ? 0 : 1;
            for (Type p : parms) {
                String parmSig = p.getSignature();
                this.firstLocalReg += "J".equals(parmSig) || "D".equals(parmSig) ? 2 : 1;
            }
            this.sourceLines = this.getSourceLines(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getSourceLines(Method obj) {
        BufferedReader sourceReader = null;
        if (this.srcInited) {
            return this.sourceLines;
        }
        try {
            this.srcLineAnnotation = SourceLineAnnotation.forEntireMethod((JavaClass)this.getClassContext().getJavaClass(), (Method)obj);
            if (this.srcLineAnnotation != null) {
                String line;
                SourceFinder sourceFinder = AnalysisContext.currentAnalysisContext().getSourceFinder();
                SourceFile sourceFile = sourceFinder.findSourceFile(this.srcLineAnnotation.getPackageName(), this.srcLineAnnotation.getSourceFile());
                sourceReader = new BufferedReader(new InputStreamReader(sourceFile.getInputStream(), "UTF-8"));
                ArrayList<String> lines = new ArrayList<String>(100);
                while ((line = sourceReader.readLine()) != null) {
                    lines.add(line);
                }
                this.sourceLines = lines.toArray(new String[lines.size()]);
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (sourceReader != null) {
                    sourceReader.close();
                }
            }
            catch (IOException ioe2) {}
        }
        this.srcInited = true;
        return this.sourceLines;
    }

    public void visitCode(Code obj) {
        int methodStart;
        String line;
        int methodLine;
        if (this.sourceLines == null) {
            return;
        }
        if (this.isAbstract) {
            return;
        }
        if ("<clinit>".equals(this.methodName) || "<init>".equals(this.methodName)) {
            return;
        }
        for (methodLine = methodStart = this.srcLineAnnotation.getStartLine() - 2; methodLine >= 0 && methodLine < this.sourceLines.length && (line = this.sourceLines[methodLine]).indexOf(this.methodName) < 0; --methodLine) {
        }
        if (methodLine < 0) {
            return;
        }
        for (int i = methodLine; i <= methodStart; ++i) {
            if (i < 0 || i >= this.sourceLines.length) {
                return;
            }
            line = this.sourceLines[i];
            if (line.indexOf("final") < 0) continue;
            return;
        }
        this.changedParms = new BitSet();
        super.visitCode(obj);
        BugInstance bi = null;
        for (int i = 0; i < this.firstLocalReg; ++i) {
            if (this.changedParms.get(i)) {
                this.changedParms.clear(i);
                continue;
            }
            String parmName = FinalParameters.getRegisterName(obj, i);
            if (bi == null) {
                bi = new BugInstance((Detector)this, BugType.FP_FINAL_PARAMETERS.name(), 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, 0);
                this.bugReporter.reportBug(bi);
            }
            bi.addString(parmName);
        }
        this.changedParms = null;
    }

    public void sawOpcode(int seen) {
        if (seen == 58 || seen >= 75 && seen <= 78) {
            this.changedParms.set(RegisterUtils.getAStoreReg((DismantleBytecode)this, seen));
        }
    }

    private static String getRegisterName(Code obj, int reg) {
        LocalVariable lv;
        LocalVariableTable lvt = obj.getLocalVariableTable();
        if (lvt != null && (lv = lvt.getLocalVariable(reg, 0)) != null) {
            return lv.getName();
        }
        return String.valueOf(reg);
    }
}

