/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.generic.Type;

public class FloatingPointLoops
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    private Set<FloatForLoop> forLoops = new HashSet<FloatForLoop>(5);

    public FloatingPointLoops(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.forLoops = new HashSet<FloatForLoop>();
        super.visitCode(obj);
        this.forLoops = null;
    }

    public void sawOpcode(int seen) {
        if (this.forLoops.size() > 0) {
            Iterator<FloatForLoop> ffl = this.forLoops.iterator();
            while (ffl.hasNext()) {
                if (ffl.next().sawOpcode(seen)) continue;
                ffl.remove();
            }
        }
        if (seen == 23 || seen == 24) {
            this.forLoops.add(new FloatForLoop(this.getRegisterOperand(), this.getPC()));
        } else if (seen >= 34 && seen <= 37) {
            this.forLoops.add(new FloatForLoop(seen - 34, this.getPC()));
        } else if (seen >= 38 && seen <= 41) {
            this.forLoops.add(new FloatForLoop(seen - 38, this.getPC()));
        }
    }

    public class FloatForLoop {
        private State state;
        private final int loopPC;
        private final int loopReg;
        private int gotoPC;

        public FloatForLoop(int reg, int pc) {
            this.loopReg = reg;
            this.loopPC = pc;
            this.state = State.SAW_LOAD;
            this.gotoPC = -1;
        }

        public boolean sawOpcode(int seen) {
            switch (this.state) {
                case SAW_LOAD: {
                    if (seen == 150 || seen == 149 || seen == 152 || seen == 151) {
                        this.state = State.SAW_CMPX;
                        return true;
                    }
                    if (seen == 182 || seen == 184 || seen == 185 || seen == 183) {
                        String methodSig = FloatingPointLoops.this.getSigConstantOperand();
                        Type t = Type.getReturnType((String)methodSig);
                        return !"V".equals(t.getSignature());
                    }
                    if (seen >= 54 && seen <= 86) break;
                    return true;
                }
                case SAW_CMPX: {
                    if (seen < 153 || seen > 158) break;
                    this.state = State.SAW_IFX;
                    this.gotoPC = FloatingPointLoops.this.getBranchTarget() - 3;
                    return this.gotoPC > FloatingPointLoops.this.getPC();
                }
                case SAW_IFX: {
                    if (FloatingPointLoops.this.getPC() < this.gotoPC - 1) {
                        return true;
                    }
                    if (FloatingPointLoops.this.getPC() == this.gotoPC - 1) {
                        int storeReg;
                        if (seen == 56 || seen == 57) {
                            storeReg = FloatingPointLoops.this.getRegisterOperand();
                        } else if (seen >= 67 && seen <= 70) {
                            storeReg = seen - 67;
                        } else if (seen >= 71 && seen <= 74) {
                            storeReg = seen - 71;
                        } else {
                            return false;
                        }
                        this.state = State.SAW_STORE;
                        return storeReg == this.loopReg;
                    }
                    return false;
                }
                case SAW_STORE: {
                    if (seen != 167 && seen != 200 || FloatingPointLoops.this.getBranchTarget() != this.loopPC) break;
                    FloatingPointLoops.this.bugReporter.reportBug(new BugInstance((Detector)FloatingPointLoops.this, "FPL_FLOATING_POINT_LOOPS", 2).addClass((PreorderVisitor)FloatingPointLoops.this).addMethod((PreorderVisitor)FloatingPointLoops.this).addSourceLine((BytecodeScanningDetector)FloatingPointLoops.this, this.loopPC));
                }
            }
            return false;
        }
    }

    static enum State {
        SAW_LOAD,
        SAW_CMPX,
        SAW_IFX,
        SAW_STORE;

    }
}

