/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.detect.MissingMethodsDetector;
import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import java.util.HashSet;
import java.util.Set;

public class HttpClientProblems
extends MissingMethodsDetector {
    private static Set<String> httpRequestClasses = new HashSet<String>();
    private static Set<String> resetMethods;
    private static Set<String> whiteListMethods;

    public HttpClientProblems(BugReporter bugReporter) {
        super(bugReporter);
    }

    @Override
    protected BugInstance makeFieldBugInstance() {
        return new BugInstance((Detector)this, BugType.HCP_HTTP_REQUEST_RESOURCES_NOT_FREED_FIELD.name(), 2);
    }

    @Override
    protected BugInstance makeLocalBugInstance() {
        return new BugInstance((Detector)this, BugType.HCP_HTTP_REQUEST_RESOURCES_NOT_FREED_LOCAL.name(), 2);
    }

    @Override
    protected boolean doesObjectNeedToBeWatched(String type) {
        return httpRequestClasses.contains(type);
    }

    @Override
    protected boolean isMethodThatShouldBeCalled(String methodName) {
        return resetMethods.contains(methodName);
    }

    @Override
    protected void processMethodParms() {
        String nameConstantOperand = this.getNameConstantOperand();
        if (!whiteListMethods.contains(nameConstantOperand)) {
            super.processMethodParms();
        }
    }

    static {
        httpRequestClasses.add("org.apache.http.client.methods.HttpGet");
        httpRequestClasses.add("org.apache.http.client.methods.HttpPut");
        httpRequestClasses.add("org.apache.http.client.methods.HttpDelete");
        httpRequestClasses.add("org.apache.http.client.methods.HttpPost");
        httpRequestClasses.add("org.apache.http.client.methods.HttpPatch");
        resetMethods = new HashSet<String>();
        resetMethods.add("reset");
        resetMethods.add("releaseConnection");
        whiteListMethods = new HashSet<String>();
        whiteListMethods.add("execute");
        whiteListMethods.add("fatal");
        whiteListMethods.add("error");
        whiteListMethods.add("info");
        whiteListMethods.add("debug");
        whiteListMethods.add("trace");
        whiteListMethods.add("println");
        whiteListMethods.add("print");
        whiteListMethods.add("format");
        whiteListMethods.add("append");
    }
}

