/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;

@OpcodeStack.CustomUserValue
public class InefficientStringBuffering
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private boolean sawLDCEmpty;

    public InefficientStringBuffering(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        if (obj.getCode() != null) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.sawLDCEmpty = false;
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        AppendType apType = AppendType.NONE;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            if (seen == 183) {
                apType = this.sawInvokeSpecial(apType);
            } else if (seen == 182) {
                if (this.sawLDCEmpty) {
                    this.dealWithEmptyString();
                }
                apType = this.sawInvokeVirtual(apType);
            } else if (seen == 167 || seen == 200) {
                int depth = this.stack.getStackDepth();
                for (int i = 0; i < depth; ++i) {
                    OpcodeStack.Item itm = this.stack.getStackItem(i);
                    itm.setUserValue((Object)AppendType.NONE);
                }
            } else if (seen == 18 || seen == 19) {
                String s;
                Constant c = this.getConstantRefOperand();
                if (c instanceof ConstantString && (s = ((ConstantString)c).getBytes(this.getConstantPool())).length() == 0) {
                    this.sawLDCEmpty = true;
                }
            } else if (OpcodeUtils.isALoad(seen)) {
                apType = AppendType.CLEAR;
            }
        }
        finally {
            this.handleOpcode(seen);
            if (apType != AppendType.NONE && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)apType);
            }
        }
    }

    private void handleOpcode(int seen) {
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
    }

    private AppendType sawInvokeVirtual(AppendType apType) {
        String calledClass = this.getClassConstantOperand();
        if ("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) {
            String methodName = this.getNameConstantOperand();
            if ("append".equals(methodName)) {
                OpcodeStack.Item itm = this.getStringBufferItemAt(1);
                AppendType appendType = apType = itm == null ? AppendType.NONE : (AppendType)((Object)itm.getUserValue());
                if (this.stack.getStackDepth() > 0) {
                    itm = this.stack.getStackItem(0);
                    Object userVal = itm.getUserValue();
                    AppendType apValue = userVal instanceof AppendType ? (AppendType)((Object)userVal) : AppendType.NONE;
                    switch (apValue) {
                        case NESTED: {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_INEFFICIENT_STRING_BUFFERING.name(), "toString".equals(this.getMethodName()) ? 3 : 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                        case TOSTRING: {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_TOSTRING_APPENDING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            break;
                        }
                    }
                }
            } else if ("toString".equals(methodName)) {
                OpcodeStack.Item itm = this.getStringBufferItemAt(0);
                apType = itm == null ? AppendType.NONE : (AppendType)((Object)itm.getUserValue());
            }
        } else if ("toString".equals(this.getNameConstantOperand()) && "()Ljava/lang/String;".equals(this.getSigConstantOperand()) && this.stack.getStackItem(0).getRegisterNumber() != 0) {
            apType = AppendType.TOSTRING;
        }
        return apType;
    }

    private void dealWithEmptyString() {
        OpcodeStack.Item itm;
        Object cons;
        OpcodeStack.Item sbItm;
        String calledClass = this.getClassConstantOperand();
        if (("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) && "append".equals(this.getNameConstantOperand()) && this.getSigConstantOperand().startsWith("(Ljava/lang/String;)") && this.stack.getStackDepth() > 1 && (sbItm = this.stack.getStackItem(1)) != null && sbItm.getUserValue() == null && (cons = (itm = this.stack.getStackItem(0)).getConstant()) instanceof String && itm.getRegisterNumber() < 0 && ((String)cons).length() == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_EMPTY_STRING_APPENDING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }

    private AppendType sawInvokeSpecial(AppendType apType) {
        String calledClass = this.getClassConstantOperand();
        if (("java/lang/StringBuffer".equals(calledClass) || "java/lang/StringBuilder".equals(calledClass)) && "<init>".equals(this.getNameConstantOperand())) {
            OpcodeStack.Item itm;
            String signature = this.getSigConstantOperand();
            if ("()V".equals(signature)) {
                OpcodeStack.Item itm2 = this.getStringBufferItemAt(2);
                if (itm2 != null) {
                    apType = AppendType.NESTED;
                }
            } else if ("(Ljava/lang/String;)V".equals(signature) && this.stack.getStackDepth() > 0 && (apType = (AppendType)((Object)(itm = this.stack.getStackItem(0)).getUserValue())) == AppendType.NESTED) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.ISB_INEFFICIENT_STRING_BUFFERING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        return apType;
    }

    private OpcodeStack.Item getStringBufferItemAt(int depth) {
        OpcodeStack.Item itm;
        String signature;
        if (this.stack.getStackDepth() > depth && ("Ljava/lang/StringBuffer;".equals(signature = (itm = this.stack.getStackItem(depth)).getSignature()) || "Ljava/lang/StringBuilder;".equals(signature))) {
            return itm;
        }
        return null;
    }

    private static enum AppendType {
        NONE,
        CLEAR,
        NESTED,
        TOSTRING;

    }
}

