/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class JUnitAssertionOddities
extends BytecodeScanningDetector {
    private static final String TESTCASE_CLASS = "junit.framework.TestCase";
    private static final String TEST_CLASS = "org.junit.Test";
    private static final String TEST_ANNOTATION_SIGNATURE = "Lorg/junit/Test;";
    private static final String OLD_ASSERT_CLASS = "junit/framework/Assert";
    private static final String NEW_ASSERT_CLASS = "org/junit/Assert";
    private BugReporter bugReporter;
    private JavaClass testCaseClass;
    private JavaClass testAnnotationClass;
    private JavaClass cls;
    private OpcodeStack stack;
    private boolean isTestCaseDerived;
    private boolean isAnnotationCapable;
    private String clsName;
    private boolean sawAssert;
    private State state;

    public JUnitAssertionOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        try {
            this.testCaseClass = Repository.lookupClass((String)TESTCASE_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testCaseClass = null;
        }
        try {
            this.testAnnotationClass = Repository.lookupClass((String)TEST_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            this.testAnnotationClass = null;
        }
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.cls = classContext.getJavaClass();
            this.clsName = this.cls.getClassName().replace('.', '/');
            this.isTestCaseDerived = this.testCaseClass != null && this.cls.instanceOf(this.testCaseClass);
            boolean bl = this.isAnnotationCapable = this.cls.getMajor() >= 5 && this.testAnnotationClass != null;
            if (this.isTestCaseDerived || this.isAnnotationCapable) {
                this.stack = new OpcodeStack();
                super.visitClassContext(classContext);
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        AnnotationEntry[] annotations;
        boolean isTestMethod;
        Method m = this.getMethod();
        boolean bl = isTestMethod = this.isTestCaseDerived && m.getName().startsWith("test");
        if (!isTestMethod && this.isAnnotationCapable && (annotations = m.getAnnotationEntries()) != null) {
            for (AnnotationEntry annotation : annotations) {
                if (!annotation.isRuntimeVisible() || !TEST_ANNOTATION_SIGNATURE.equals(annotation.getAnnotationType())) continue;
                isTestMethod = true;
                break;
            }
        }
        if (isTestMethod) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.state = State.SAW_NOTHING;
            this.sawAssert = false;
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void sawOpcode(int seen) {
        block31: {
            block32: {
                block28: {
                    block30: {
                        block29: {
                            userValue = null;
                            try {
                                this.stack.precomputation((DismantleBytecode)this);
                                if (seen != 184) ** GOTO lbl70
                                clsName = this.getClassConstantOperand();
                                if (!"junit/framework/Assert".equals(clsName) && !"org/junit/Assert".equals(clsName)) ** GOTO lbl65
                                this.sawAssert = true;
                                methodName = this.getNameConstantOperand();
                                if (!"assertEquals".equals(methodName)) ** GOTO lbl58
                                signature = this.getSigConstantOperand();
                                argTypes = Type.getArgumentTypes((String)signature);
                                if (argTypes.length != 2 && argTypes.length != 3 || this.stack.getStackDepth() < 2) break block28;
                                item1 = this.stack.getStackItem(1);
                                cons1 = item1.getConstant();
                                if (cons1 == null || !argTypes[argTypes.length - 1].equals((Object)Type.BOOLEAN) || !argTypes[argTypes.length - 2].equals((Object)Type.BOOLEAN)) break block29;
                                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JAO_JUNIT_ASSERTION_ODDITIES_BOOLEAN_ASSERT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                            }
                            catch (Throwable var11_14) {
                                TernaryPatcher.pre(this.stack, seen);
                                this.stack.sawOpcode((DismantleBytecode)this, seen);
                                TernaryPatcher.post(this.stack, seen);
                                if (userValue != null && this.stack.getStackDepth() > 0) {
                                    item = this.stack.getStackItem(0);
                                    item.setUserValue(userValue);
                                }
                                throw var11_14;
                            }
                            TernaryPatcher.pre(this.stack, seen);
                            this.stack.sawOpcode((DismantleBytecode)this, seen);
                            TernaryPatcher.post(this.stack, seen);
                            if (userValue != null && this.stack.getStackDepth() > 0) {
                                item = this.stack.getStackItem(0);
                                item.setUserValue((Object)userValue);
                            }
                            return;
                        }
                        item0 = this.stack.getStackItem(0);
                        if (item0.getConstant() == null || item1.getConstant() != null || argTypes.length != 2 && this.isFloatingPtPrimitive(item0.getSignature())) break block30;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JAO_JUNIT_ASSERTION_ODDITIES_ACTUAL_CONSTANT.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        TernaryPatcher.pre(this.stack, seen);
                        this.stack.sawOpcode((DismantleBytecode)this, seen);
                        TernaryPatcher.post(this.stack, seen);
                        if (userValue != null && this.stack.getStackDepth() > 0) {
                            item = this.stack.getStackItem(0);
                            item.setUserValue((Object)userValue);
                        }
                        return;
                    }
                    if (!argTypes[argTypes.length - 1].equals((Object)Type.OBJECT) || !argTypes[argTypes.length - 2].equals((Object)Type.OBJECT) || !"Ljava/lang/Double;".equals(item0.getSignature()) || !"Ljava/lang/Double;".equals(item1.getSignature())) break block28;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JAO_JUNIT_ASSERTION_ODDITIES_INEXACT_DOUBLE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    TernaryPatcher.pre(this.stack, seen);
                    this.stack.sawOpcode((DismantleBytecode)this, seen);
                    TernaryPatcher.post(this.stack, seen);
                    if (userValue != null && this.stack.getStackDepth() > 0) {
                        item = this.stack.getStackItem(0);
                        item.setUserValue((Object)userValue);
                    }
                    return;
                }
                break block32;
lbl58:
                // 1 sources

                if ("assertNotNull".equals(methodName)) {
                    if (this.stack.getStackDepth() > 0 && "valueOf".equals(this.stack.getStackItem(0).getUserValue())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JAO_JUNIT_ASSERTION_ODDITIES_IMPOSSIBLE_NULL.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                } else if ("assertTrue".equals(methodName) && (this.state == State.SAW_ICONST_0 || this.state == State.SAW_EQUALS)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JAO_JUNIT_ASSERTION_ODDITIES_USE_ASSERT_EQUALS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                break block32;
lbl65:
                // 1 sources

                methodName = this.getNameConstantOperand();
                sig = this.getSigConstantOperand();
                if (clsName.startsWith("java/lang/") && "valueOf".equals(methodName) && sig.indexOf(")Ljava/lang/") >= 0) {
                    userValue = "valueOf";
                }
                break block32;
lbl70:
                // 1 sources

                if (seen == 191 && this.stack.getStackDepth() > 0 && "Ljava/lang/AssertionError;".equals(throwClass = (item = this.stack.getStackItem(0)).getSignature())) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.JAO_JUNIT_ASSERTION_ODDITIES_ASSERT_USED.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.sawAssert = true;
                }
            }
            switch (1.$SwitchMap$com$mebigfatguy$fbcontrib$detect$JUnitAssertionOddities$State[this.state.ordinal()]) {
                case 1: 
                case 2: {
                    if (seen == 160) {
                        this.state = State.SAW_IF_ICMPNE;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 3: {
                    if (seen == 4) {
                        this.state = State.SAW_ICONST_1;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 4: {
                    if (seen == 167) {
                        this.state = State.SAW_GOTO;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case 5: {
                    if (seen == 3) {
                        this.state = State.SAW_ICONST_0;
                        break;
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                default: {
                    this.state = State.SAW_NOTHING;
                }
            }
            if (seen != 182 && seen != 184 && seen != 183) break block31;
            lcName = this.getNameConstantOperand().toLowerCase();
            if (seen == 182) {
                sig = this.getSigConstantOperand();
                if ("equals".equals(lcName) && "(Ljava/lang/Object;)Z".equals(sig)) {
                    this.state = State.SAW_EQUALS;
                }
            }
            if (!this.clsName.equals(this.getClassConstantOperand()) && !lcName.contains("assert") && !lcName.contains("verify")) break block31;
            this.sawAssert = true;
        }
        TernaryPatcher.pre(this.stack, seen);
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        TernaryPatcher.post(this.stack, seen);
        if (userValue != null && this.stack.getStackDepth() > 0) {
            item = this.stack.getStackItem(0);
            item.setUserValue((Object)userValue);
        }
    }

    public boolean isFloatingPtPrimitive(String signature) {
        return "D".equals(signature) || "F".equals(signature);
    }

    private static enum State {
        SAW_NOTHING,
        SAW_IF_ICMPNE,
        SAW_ICONST_1,
        SAW_GOTO,
        SAW_ICONST_0,
        SAW_EQUALS;

    }
}

