/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class LiteralStringComparison
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private List<LookupDetails> lookupSwitches;

    public LiteralStringComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.lookupSwitches = new ArrayList<LookupDetails>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.lookupSwitches = null;
        }
    }

    public boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(18) || bytecodeSet.get(19));
    }

    public void visitCode(Code obj) {
        if (this.prescreen(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.lookupSwitches.clear();
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        OpcodeStack.Item item2;
        String hashCodedStringRef = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: {
                    if (!"java/lang/String".equals(this.getClassConstantOperand())) return;
                    String calledMethodName = this.getNameConstantOperand();
                    String calledMethodSig = this.getSigConstantOperand();
                    if ("equals".equals(calledMethodName) && "(Ljava/lang/Object;)Z".equals(calledMethodSig) || "compareTo".equals(calledMethodName) && "(Ljava/lang/String;)I".equals(calledMethodSig) || "equalsIgnoreCase".equals(calledMethodName) && "(Ljava/lang/String;)Z".equals(calledMethodSig)) {
                        if (this.stack.getStackDepth() <= 0) return;
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        Object constant = itm.getConstant();
                        if (constant == null) return;
                        if (!constant.getClass().equals(String.class)) return;
                        if (this.lookupSwitchOnString()) return;
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "LSC_LITERAL_STRING_COMPARISON", 1).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        return;
                    }
                    if (!"hashCode".equals(calledMethodName)) return;
                    if (this.stack.getStackDepth() <= 0) return;
                    item2 = this.stack.getStackItem(0);
                    int reg = item2.getRegisterNumber();
                    if (reg >= 0) {
                        hashCodedStringRef = String.valueOf(reg);
                        return;
                    }
                    XField xf = item2.getXField();
                    if (xf != null) {
                        hashCodedStringRef = xf.getName();
                        return;
                    }
                    XMethod xm = item2.getReturnValueOf();
                    if (xm == null) return;
                    hashCodedStringRef = xm.toString();
                    return;
                }
                case 171: {
                    if (this.stack.getStackDepth() <= 0) return;
                    item = this.stack.getStackItem(0);
                    String stringRef = (String)item.getUserValue();
                    if (stringRef == null) return;
                    int[] offsets = this.getSwitchOffsets();
                    BitSet bs = new BitSet();
                    int pc = this.getPC();
                    int[] nArray = offsets;
                    int n = nArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            this.lookupSwitches.add(new LookupDetails(stringRef, bs));
                            return;
                        }
                        int offset = nArray[n2];
                        bs.set(pc + offset);
                        ++n2;
                    }
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (hashCodedStringRef != null && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                item.setUserValue(hashCodedStringRef);
            }
            if (!this.lookupSwitches.isEmpty()) {
                int innerMostSwitch = this.lookupSwitches.size() - 1;
                LookupDetails details = this.lookupSwitches.get(innerMostSwitch);
                if (details.switchTargets.get(this.getPC()) && this.stack.getStackDepth() > 0) {
                    item2 = this.stack.getStackItem(0);
                    item2.setUserValue((Object)details.getStringReference());
                }
                if (this.getPC() >= details.getSwitchTargets().previousSetBit(Integer.MAX_VALUE)) {
                    this.lookupSwitches.remove(innerMostSwitch);
                }
            }
        }
    }

    private boolean lookupSwitchOnString() {
        if (this.stack.getStackDepth() > 1) {
            OpcodeStack.Item item = this.stack.getStackItem(1);
            String stringRef = (String)item.getUserValue();
            if (stringRef == null) {
                return false;
            }
            if (!this.lookupSwitches.isEmpty()) {
                LookupDetails details = this.lookupSwitches.get(this.lookupSwitches.size() - 1);
                return stringRef.equals(details.getStringReference());
            }
        }
        return true;
    }

    static class LookupDetails {
        private String stringReference;
        private BitSet switchTargets;

        public LookupDetails(String stringRef, BitSet switchOffs) {
            this.stringReference = stringRef;
            this.switchTargets = switchOffs;
        }

        public String getStringReference() {
            return this.stringReference;
        }

        public BitSet getSwitchTargets() {
            return this.switchTargets;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

