/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class LoggerOddities
extends BytecodeScanningDetector {
    private static JavaClass THROWABLE_CLASS;
    private static Set<String> LOGGER_METHODS;
    private static Pattern BAD_FORMATTING_ANCHOR;
    private static Pattern FORMATTER_ANCHOR;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String nameOfThisClass;

    public LoggerOddities(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.nameOfThisClass = classContext.getJavaClass().getClassName();
            int subclassIndex = this.nameOfThisClass.indexOf(36);
            while (subclassIndex >= 0) {
                String simpleName = this.nameOfThisClass.substring(subclassIndex + 1);
                try {
                    Integer.parseInt(simpleName);
                    this.nameOfThisClass = this.nameOfThisClass.substring(0, subclassIndex);
                    subclassIndex = this.nameOfThisClass.indexOf(36);
                }
                catch (NumberFormatException nfe) {
                    subclassIndex = -1;
                }
            }
            this.nameOfThisClass = this.nameOfThisClass.replace('.', '/');
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        Method m = this.getMethod();
        if ("<init>".equals(m.getName())) {
            Type[] types;
            for (Type t : types = Type.getArgumentTypes((String)m.getSignature())) {
                String parmSig = t.getSignature();
                if (!"Lorg/slf4j/Logger;".equals(parmSig) && !"Lorg/apache/log4j/Logger;".equals(parmSig) && !"Lorg/apache/commons/logging/Log;".equals(parmSig)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_SUSPECT_LOG_PARAMETER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this));
            }
        }
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        block43: {
            String ldcClassName = null;
            String seenMethodName = null;
            int exMessageReg = -1;
            Integer arraySize = null;
            try {
                OpcodeStack.Item arrayItem;
                Integer size;
                this.stack.precomputation((DismantleBytecode)this);
                if (seen == 18 || seen == 19) {
                    Constant c = this.getConstantRefOperand();
                    if (c instanceof ConstantClass) {
                        ConstantPool pool = this.getConstantPool();
                        ldcClassName = ((ConstantUtf8)pool.getConstant(((ConstantClass)c).getNameIndex())).getBytes();
                    }
                } else if (seen == 184) {
                    this.lookForSuspectClasses();
                } else if ((seen == 182 || seen == 185) && THROWABLE_CLASS != null) {
                    String callingClsName;
                    String mthName = this.getNameConstantOperand();
                    if ("getName".equals(mthName)) {
                        if (this.stack.getStackDepth() >= 1) {
                            OpcodeStack.Item stackItem = this.stack.getStackItem(0);
                            ldcClassName = (String)stackItem.getUserValue();
                        }
                    } else if ("getMessage".equals(mthName)) {
                        String callingClsName2 = this.getClassConstantOperand();
                        JavaClass cls = Repository.lookupClass((String)callingClsName2);
                        if (cls.instanceOf(THROWABLE_CLASS) && this.stack.getStackDepth() > 0) {
                            OpcodeStack.Item exItem = this.stack.getStackItem(0);
                            exMessageReg = exItem.getRegisterNumber();
                        }
                    } else if (LOGGER_METHODS.contains(mthName)) {
                        this.checkForProblemsWithLoggerMethods();
                    } else if ("toString".equals(mthName) && ("java/lang/StringBuilder".equals(callingClsName = this.getClassConstantOperand()) || "java/lang/StringBuffer".equals(callingClsName))) {
                        seenMethodName = mthName;
                    }
                } else if (seen == 183) {
                    this.checkForLoggerParam();
                } else if (seen == 189) {
                    OpcodeStack.Item sizeItem;
                    Object con;
                    if (this.stack.getStackDepth() > 0 && (con = (sizeItem = this.stack.getStackItem(0)).getConstant()) instanceof Integer) {
                        arraySize = (Integer)con;
                    }
                } else if (seen == 83 && this.stack.getStackDepth() >= 3 && (size = (Integer)(arrayItem = this.stack.getStackItem(2)).getUserValue()) != null && size > 0 && this.hasExceptionOnStack()) {
                    arrayItem.setUserValue((Object)(-size.intValue()));
                }
                TernaryPatcher.pre(this.stack, seen);
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
                break block43;
            }
            finally {
                TernaryPatcher.pre(this.stack, seen);
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                TernaryPatcher.post(this.stack, seen);
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    if (ldcClassName != null) {
                        item.setUserValue((Object)ldcClassName);
                    } else if (seenMethodName != null) {
                        item.setUserValue(seenMethodName);
                    } else if (exMessageReg >= 0) {
                        item.setUserValue((Object)exMessageReg);
                    } else if (arraySize != null) {
                        item.setUserValue(arraySize);
                    }
                }
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                if (ldcClassName != null) {
                    item.setUserValue((Object)ldcClassName);
                } else if (seenMethodName != null) {
                    item.setUserValue(seenMethodName);
                } else if (exMessageReg >= 0) {
                    item.setUserValue((Object)exMessageReg);
                } else if (arraySize != null) {
                    item.setUserValue((Object)arraySize);
                }
            }
        }
    }

    private void checkForProblemsWithLoggerMethods() throws ClassNotFoundException {
        String callingClsName = this.getClassConstantOperand();
        if (callingClsName.endsWith("Log") || callingClsName.endsWith("Logger")) {
            String signature;
            String sig = this.getSigConstantOperand();
            if ("(Ljava/lang/String;Ljava/lang/Throwable;)V".equals(sig) || "(Ljava/lang/Object;Ljava/lang/Throwable;)V".equals(sig)) {
                if (this.stack.getStackDepth() >= 2) {
                    OpcodeStack.Item exItem = this.stack.getStackItem(0);
                    OpcodeStack.Item msgItem = this.stack.getStackItem(1);
                    Object exReg = msgItem.getUserValue();
                    if (exReg instanceof Integer && ((Integer)exReg).intValue() == exItem.getRegisterNumber()) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_STUTTERED_MESSAGE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            } else if ("(Ljava/lang/Object;)V".equals(sig)) {
                JavaClass clazz;
                if (this.stack.getStackDepth() > 0 && (clazz = this.stack.getStackItem(0).getJavaClass()) != null && clazz.instanceOf(THROWABLE_CLASS)) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_LOGGER_LOST_EXCEPTION_STACK_TRACE.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
            } else if ("org/slf4j/Logger".equals(callingClsName) && ("(Ljava/lang/String;)V".equals(signature = this.getSigConstantOperand()) || "(Ljava/lang/String;Ljava/lang/Object;)V".equals(signature) || "(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V".equals(signature) || "(Ljava/lang/String;[Ljava/lang/Object;)V".equals(signature))) {
                int numParms = Type.getArgumentTypes((String)signature).length;
                if (this.stack.getStackDepth() >= numParms) {
                    OpcodeStack.Item formatItem = this.stack.getStackItem(numParms - 1);
                    Object con = formatItem.getConstant();
                    if (con instanceof String) {
                        Matcher m = BAD_FORMATTING_ANCHOR.matcher((String)con);
                        if (m.find()) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_INVALID_FORMATTING_ANCHOR.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        } else {
                            int actualParms = this.getSLF4JParmCount(signature);
                            if (actualParms != -1) {
                                int expectedParms = LoggerOddities.countAnchors((String)con);
                                boolean hasEx = this.hasExceptionOnStack();
                                if (!hasEx && expectedParms != actualParms || hasEx && expectedParms != actualParms - 1 && expectedParms != actualParms) {
                                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_INCORRECT_NUMBER_OF_ANCHOR_PARAMETERS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString("Expected: " + expectedParms).addString("Actual: " + actualParms));
                                }
                            }
                        }
                    } else if ("toString".equals(formatItem.getUserValue())) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_APPENDED_STRING_IN_FORMAT_STRING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
            }
        }
    }

    private void checkForLoggerParam() {
        String sig;
        Type[] types;
        String cls;
        if ("<init>".equals(this.getNameConstantOperand()) && ((cls = this.getClassConstantOperand()).startsWith("java/") || cls.startsWith("javax/")) && cls.endsWith("Exception") && (types = Type.getArgumentTypes((String)(sig = this.getSigConstantOperand()))).length <= this.stack.getStackDepth()) {
            for (int i = 0; i < types.length; ++i) {
                OpcodeStack.Item item;
                String cons;
                if (!"Ljava/lang/String;".equals(types[i].getSignature()) || (cons = (String)(item = this.stack.getStackItem(types.length - i - 1)).getConstant()) == null || !cons.contains("{}")) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_EXCEPTION_WITH_LOGGER_PARMS.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                break;
            }
        }
    }

    private void lookForSuspectClasses() {
        OpcodeStack.Item item;
        String signature;
        String callingClsName = this.getClassConstantOperand();
        String mthName = this.getNameConstantOperand();
        String loggingClassName = null;
        int loggingPriority = 2;
        if ("org/slf4j/LoggerFactory".equals(callingClsName) && "getLogger".equals(mthName)) {
            signature = this.getSigConstantOperand();
            if ("(Ljava/lang/Class;)Lorg/slf4j/Logger;".equals(signature)) {
                if (this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    loggingClassName = (String)item.getUserValue();
                }
            } else if ("(Ljava/lang/String;)Lorg/slf4j/Logger;".equals(signature) && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                loggingClassName = (String)item.getConstant();
                if (loggingClassName != null) {
                    loggingClassName = loggingClassName.replace('.', '/');
                }
                loggingPriority = 3;
            }
        } else if ("org/apache/log4j/Logger".equals(callingClsName) && "getLogger".equals(mthName)) {
            signature = this.getSigConstantOperand();
            if ("(Ljava/lang/Class;)Lorg/apache/log4j/Logger;".equals(signature)) {
                if (this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    loggingClassName = (String)item.getUserValue();
                }
            } else if ("(Ljava/lang/String;)Lorg/apache/log4j/Logger;".equals(signature)) {
                if (this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    loggingClassName = (String)item.getConstant();
                    Object userValue = item.getUserValue();
                    if (loggingClassName != null) {
                        loggingClassName = loggingClassName.replace('.', '/');
                        loggingPriority = 3;
                    } else if (userValue instanceof String) {
                        loggingClassName = (String)userValue;
                        loggingClassName = loggingClassName.replace('.', '/');
                    }
                }
            } else if ("(Ljava/lang/String;Lorg/apache/log4j/spi/LoggerFactory;)Lorg/apache/log4j/Logger;".equals(signature) && this.stack.getStackDepth() > 1) {
                item = this.stack.getStackItem(1);
                loggingClassName = (String)item.getConstant();
                if (loggingClassName != null) {
                    loggingClassName = loggingClassName.replace('.', '/');
                }
                loggingPriority = 3;
            }
        } else if ("org/apache/commons/logging/LogFactory".equals(callingClsName) && "getLog".equals(mthName)) {
            signature = this.getSigConstantOperand();
            if ("(Ljava/lang/Class;)Lorg/apache/commons/logging/Log;".equals(signature)) {
                if (this.stack.getStackDepth() > 0) {
                    item = this.stack.getStackItem(0);
                    loggingClassName = (String)item.getUserValue();
                }
            } else if ("(Ljava/lang/String;)Lorg/apache/commons/logging/Log;".equals(signature) && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                loggingClassName = (String)item.getConstant();
                if (loggingClassName != null) {
                    loggingClassName = loggingClassName.replace('.', '/');
                }
                loggingPriority = 3;
            }
        }
        if (loggingClassName != null && this.stack.getStackDepth() > 0 && !loggingClassName.equals(this.nameOfThisClass)) {
            boolean isAnonClassPrefix;
            boolean isPrefix = this.nameOfThisClass.startsWith(loggingClassName);
            if (isPrefix) {
                String anonClass = this.nameOfThisClass.substring(loggingClassName.length());
                isAnonClassPrefix = anonClass.matches("(\\$\\d+)+");
            } else {
                isAnonClassPrefix = false;
            }
            if (!isAnonClassPrefix) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LO_SUSPECT_LOG_CLASS.name(), loggingPriority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(loggingClassName).addString(this.nameOfThisClass));
            }
        }
    }

    private static int countAnchors(String formatString) {
        Matcher m = FORMATTER_ANCHOR.matcher(formatString);
        int count = 0;
        int start = 0;
        while (m.find(start)) {
            ++count;
            start = m.end();
        }
        return count;
    }

    private int getSLF4JParmCount(String signature) {
        if ("(Ljava/lang/String;Ljava/lang/Object;)V".equals(signature)) {
            return 1;
        }
        if ("(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V".equals(signature)) {
            return 2;
        }
        OpcodeStack.Item item = this.stack.getStackItem(0);
        Integer size = (Integer)item.getUserValue();
        if (size != null) {
            return Math.abs(size);
        }
        return -1;
    }

    private boolean hasExceptionOnStack() {
        try {
            for (int i = 0; i < this.stack.getStackDepth() - 1; ++i) {
                Integer sz;
                String name;
                JavaClass cls;
                OpcodeStack.Item item = this.stack.getStackItem(i);
                String sig = item.getSignature();
                if (!(sig.startsWith("L") ? (cls = Repository.lookupClass((String)(name = sig.substring(1, sig.length() - 1)))).instanceOf(THROWABLE_CLASS) : sig.startsWith("[") && (sz = (Integer)item.getUserValue()) != null && sz < 0)) continue;
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return true;
        }
    }

    static {
        BAD_FORMATTING_ANCHOR = Pattern.compile("\\{[0-9]\\}");
        FORMATTER_ANCHOR = Pattern.compile("\\{\\}");
        try {
            THROWABLE_CLASS = Repository.lookupClass((String)"java/lang/Throwable");
            LOGGER_METHODS = new HashSet<String>();
            LOGGER_METHODS.add("trace");
            LOGGER_METHODS.add("debug");
            LOGGER_METHODS.add("info");
            LOGGER_METHODS.add("warn");
            LOGGER_METHODS.add("error");
            LOGGER_METHODS.add("fatal");
        }
        catch (ClassNotFoundException cnfe) {
            THROWABLE_CLASS = null;
        }
    }
}

