/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import com.mebigfatguy.fbcontrib.utils.ToString;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

@OpcodeStack.CustomUserValue
public class LostExceptionStackTrace
extends BytecodeScanningDetector {
    private static JavaClass throwableClass;
    private static JavaClass assertionClass;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private CodeException[] exceptions;
    private Set<CatchInfo> catchInfos;
    private Map<Integer, Boolean> exReg;
    private boolean lastWasExitPoint = false;

    public LostExceptionStackTrace(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            if (throwableClass != null && !LostExceptionStackTrace.isPre14Class(classContext.getJavaClass())) {
                this.stack = new OpcodeStack();
                this.catchInfos = new HashSet<CatchInfo>();
                this.exReg = new HashMap<Integer, Boolean>();
                super.visitClassContext(classContext);
            }
        }
        finally {
            this.stack = null;
            this.catchInfos = null;
            this.exceptions = null;
            this.exReg = null;
        }
    }

    public boolean prescreen(Code code, Method method) {
        if (method.isSynthetic()) {
            return false;
        }
        CodeException[] ce = code.getExceptionTable();
        if (ce == null || ce.length == 0) {
            return false;
        }
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(191);
    }

    public void visitCode(Code obj) {
        if (this.prescreen(obj, this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.catchInfos.clear();
            this.exceptions = this.collectExceptions(obj.getExceptionTable());
            this.exReg.clear();
            this.lastWasExitPoint = false;
            super.visitCode(obj);
        }
    }

    public CodeException[] collectExceptions(CodeException ... exs) {
        ArrayList<CodeException> filteredEx = new ArrayList<CodeException>();
        for (CodeException ce : exs) {
            if (ce.getCatchType() == 0 || ce.getStartPC() >= ce.getEndPC() || ce.getEndPC() > ce.getHandlerPC()) continue;
            filteredEx.add(ce);
        }
        return filteredEx.toArray(new CodeException[filteredEx.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean markAsValid = false;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            int pc = this.getPC();
            for (CodeException ex : this.exceptions) {
                if (pc == ex.getEndPC()) {
                    if (seen >= 172 && seen <= 177) {
                        this.addCatchBlock(ex.getHandlerPC(), Integer.MAX_VALUE);
                        continue;
                    }
                    if (seen == 167 || seen == 200) {
                        this.addCatchBlock(ex.getHandlerPC(), this.getBranchTarget());
                        continue;
                    }
                    this.addCatchBlock(ex.getHandlerPC(), Integer.MAX_VALUE);
                    continue;
                }
                if (pc != ex.getHandlerPC()) continue;
                this.removePreviousHandlers(pc);
            }
            Iterator<CatchInfo> it = this.catchInfos.iterator();
            while (it.hasNext()) {
                try {
                    CatchInfo catchInfo = it.next();
                    if (pc == catchInfo.getStart()) {
                        if (this.updateExceptionRegister(catchInfo, seen, pc)) break;
                        it.remove();
                        break;
                    }
                    if (pc > catchInfo.getFinish()) {
                        it.remove();
                        break;
                    }
                    if (pc <= catchInfo.getStart() || pc > catchInfo.getFinish()) continue;
                    if (seen == 183) {
                        if ("<init>".equals(this.getNameConstantOperand())) {
                            String className = this.getClassConstantOperand();
                            JavaClass exClass = Repository.lookupClass((String)className);
                            if (!exClass.instanceOf(throwableClass)) continue;
                            String sig = this.getSigConstantOperand();
                            if (sig.indexOf("Exception") >= 0 || sig.indexOf("Throwable") >= 0 || sig.indexOf("Error") >= 0) {
                                markAsValid = true;
                                break;
                            }
                            if (!exClass.instanceOf(assertionClass)) continue;
                            markAsValid = true;
                            break;
                        }
                        if (!this.isPossibleExBuilder(catchInfo.getRegister())) continue;
                        markAsValid = true;
                        continue;
                    }
                    if (seen == 182) {
                        if ("initCause".equals(this.getNameConstantOperand())) {
                            String className = this.getClassConstantOperand();
                            JavaClass exClass = Repository.lookupClass((String)className);
                            if (!exClass.instanceOf(throwableClass) || this.stack.getStackDepth() <= 1) continue;
                            OpcodeStack.Item itm = this.stack.getStackItem(1);
                            int reg = itm.getRegisterNumber();
                            if (reg >= 0) {
                                this.exReg.put(reg, Boolean.TRUE);
                            }
                            markAsValid = true;
                            continue;
                        }
                        if ("getTargetException".equals(this.getNameConstantOperand()) && "java/lang/reflect/InvocationTargetException".equals(this.getClassConstantOperand())) {
                            markAsValid = true;
                            continue;
                        }
                        if (!this.isPossibleExBuilder(catchInfo.getRegister())) continue;
                        markAsValid = true;
                        continue;
                    }
                    if (seen == 185 || seen == 184) {
                        if (!this.isPossibleExBuilder(catchInfo.getRegister())) continue;
                        markAsValid = true;
                        continue;
                    }
                    if (seen == 191) {
                        OpcodeStack.Item itm;
                        if (this.stack.getStackDepth() <= 0 || (itm = this.stack.getStackItem(0)).getRegisterNumber() == catchInfo.getRegister() || itm.getUserValue() != null) continue;
                        if (!LostExceptionStackTrace.isPre14Class(itm.getJavaClass())) {
                            int priority = this.getPrevOpcode(1) == 195 ? 3 : 2;
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.LEST_LOST_EXCEPTION_STACK_TRACE.name(), priority).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                        it.remove();
                        break;
                    }
                    if (seen == 58 || seen >= 75 && seen <= 78) {
                        if (this.lastWasExitPoint) {
                            this.catchInfos.clear();
                            break;
                        }
                        if (this.stack.getStackDepth() <= 0) continue;
                        OpcodeStack.Item itm = this.stack.getStackItem(0);
                        int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                        this.exReg.put(reg, (Boolean)itm.getUserValue());
                        if (reg != catchInfo.getRegister() || catchInfo.getFinish() != Integer.MAX_VALUE) continue;
                        it.remove();
                        continue;
                    }
                    if (OpcodeUtils.isALoad(seen)) {
                        Boolean valid = this.exReg.get(RegisterUtils.getALoadReg((DismantleBytecode)this, seen));
                        if (valid == null) continue;
                        markAsValid = valid;
                        continue;
                    }
                    if (seen < 172 || seen > 177) continue;
                    this.removeIndeterminateHandlers(pc);
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    this.bugReporter.reportMissingClass(cnfe);
                    it.remove();
                }
            }
            this.lastWasExitPoint = seen >= 172 && seen <= 177 || seen == 167 || seen == 200 || seen == 191;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (markAsValid && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item itm = this.stack.getStackItem(0);
                itm.setUserValue((Object)Boolean.TRUE);
            }
        }
    }

    public boolean isPossibleExBuilder(int excReg) throws ClassNotFoundException {
        JavaClass retCls;
        String sig = this.getSigConstantOperand();
        Type returnType = Type.getReturnType((String)sig);
        String returnSig = returnType.getSignature();
        if (returnSig.startsWith("L") && (retCls = Repository.lookupClass((String)(returnSig = returnSig.substring(1, returnSig.length() - 1)))).instanceOf(throwableClass)) {
            int numParms = Type.getArgumentTypes((String)sig).length;
            if (this.stack.getStackDepth() >= numParms) {
                for (int p = 0; p < numParms; ++p) {
                    OpcodeStack.Item item = this.stack.getStackItem(p);
                    if (item.getRegisterNumber() != excReg) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPre14Class(JavaClass cls) {
        return cls != null && cls.getMajor() < 48;
    }

    private void removePreviousHandlers(int pc) {
        Iterator<CatchInfo> it = this.catchInfos.iterator();
        while (it.hasNext()) {
            CatchInfo ci = it.next();
            if (ci.getStart() >= pc) continue;
            it.remove();
        }
    }

    private void removeIndeterminateHandlers(int pc) {
        Iterator<CatchInfo> it = this.catchInfos.iterator();
        while (it.hasNext()) {
            CatchInfo ci = it.next();
            if (ci.getStart() >= pc || ci.getFinish() != Integer.MAX_VALUE) continue;
            it.remove();
        }
    }

    private boolean updateExceptionRegister(CatchInfo ci, int seen, int pc) {
        if (seen == 58 || seen >= 75 && seen <= 78) {
            int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
            ci.setReg(reg);
            this.exReg.put(reg, Boolean.TRUE);
            LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
            if (lvt != null) {
                LocalVariable lv = lvt.getLocalVariable(reg, pc + 2);
                if (lv != null) {
                    int finish = lv.getStartPC() + lv.getLength();
                    if (finish < ci.getFinish()) {
                        ci.setFinish(finish);
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    private void addCatchBlock(int start, int finish) {
        CatchInfo ci = new CatchInfo(start, finish);
        this.catchInfos.add(ci);
    }

    static {
        try {
            throwableClass = Repository.lookupClass((String)"java/lang/Throwable");
            assertionClass = Repository.lookupClass((String)"java/lang/AssertionError");
        }
        catch (ClassNotFoundException cnfe) {
            throwableClass = null;
            assertionClass = null;
        }
    }

    private static class CatchInfo {
        private final int catchStart;
        private int catchFinish;
        private int exReg;

        public CatchInfo(int start, int finish) {
            this.catchStart = start;
            this.catchFinish = finish;
            this.exReg = -1;
        }

        public void setReg(int reg) {
            this.exReg = reg;
        }

        public int getStart() {
            return this.catchStart;
        }

        public int getFinish() {
            return this.catchFinish;
        }

        public void setFinish(int finish) {
            this.catchFinish = finish;
        }

        public int getRegister() {
            return this.exReg;
        }

        public String toString() {
            return ToString.build(this);
        }
    }
}

