/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

@OpcodeStack.CustomUserValue
public class MethodReturnsConstant
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private int returnRegister;
    private Map<Integer, Object> registerConstants;
    private Object returnConstant;
    private boolean methodSuspect;
    private int returnPC;

    public MethodReturnsConstant(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            this.stack = new OpcodeStack();
            this.registerConstants = new HashMap<Integer, Object>();
            super.visitClassContext(classContext);
        }
        finally {
            this.stack = null;
            this.registerConstants = null;
        }
    }

    public void visitCode(Code obj) {
        Method m = this.getMethod();
        int aFlags = m.getAccessFlags();
        if (!((aFlags & 2) == 0 && (aFlags & 8) == 0 || (aFlags & 0x1000) != 0 || m.getSignature().endsWith(")Z"))) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            this.returnRegister = -1;
            this.returnConstant = null;
            this.registerConstants.clear();
            this.methodSuspect = true;
            this.returnPC = -1;
            super.visitCode(obj);
            if (this.methodSuspect && this.returnConstant != null) {
                BugInstance bi = new BugInstance((Detector)this, BugType.MRC_METHOD_RETURNS_CONSTANT.name(), (aFlags & 2) != 0 ? 2 : 3).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this);
                if (this.returnPC >= 0) {
                    bi.addSourceLine((BytecodeScanningDetector)this, this.returnPC);
                }
                bi.addString(this.returnConstant.toString());
                this.bugReporter.reportBug(bi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        boolean sawSBToString = false;
        try {
            if (!this.methodSuspect) {
                return;
            }
            this.stack.precomputation((DismantleBytecode)this);
            if (seen >= 172 && seen <= 176) {
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Integer register = item.getRegisterNumber();
                    if (this.registerConstants.containsKey(register) && this.registerConstants.get(register) == null) {
                        this.methodSuspect = false;
                        return;
                    }
                    Object constant = item.getConstant();
                    if (constant == null) {
                        this.methodSuspect = false;
                        return;
                    }
                    if (Boolean.TRUE.equals(item.getUserValue()) && "".equals(constant)) {
                        this.methodSuspect = false;
                        return;
                    }
                    if (this.returnConstant != null && !this.returnConstant.equals(constant)) {
                        this.methodSuspect = false;
                        return;
                    }
                    this.returnRegister = item.getRegisterNumber();
                    this.returnConstant = constant;
                }
            } else if (seen == 167 || seen == 200) {
                if (this.stack.getStackDepth() > 0) {
                    this.methodSuspect = false;
                }
            } else if (seen == 182) {
                String clsName = this.getClassConstantOperand();
                if (clsName.startsWith("java/lang/StringB")) {
                    sawSBToString = "toString".equals(this.getNameConstantOperand());
                }
            } else if (seen >= 54 && seen <= 78 || seen == 132) {
                Object constant;
                int register = this.getRegisterOperand();
                if (this.returnRegister != -1 && register == this.returnRegister) {
                    this.methodSuspect = false;
                }
                if (this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    Object constant2 = item.getConstant();
                    if (this.registerConstants.containsKey(register)) {
                        if (constant2 == null || !constant2.equals(this.registerConstants.get(register))) {
                            this.registerConstants.put(register, null);
                        }
                    } else if (item.getSignature().contains("[")) {
                        this.registerConstants.put(register, null);
                    } else {
                        this.registerConstants.put(register, constant2);
                    }
                } else {
                    this.registerConstants.put(register, null);
                }
                if (this.returnRegister == register && (constant = this.registerConstants.get(this.returnRegister)) != null) {
                    this.methodSuspect = false;
                }
            }
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (sawSBToString && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)Boolean.TRUE);
            }
        }
    }
}

