/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.TernaryPatcher;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.generic.Type;

public abstract class MissingMethodsDetector
extends BytecodeScanningDetector {
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private String clsSignature;
    private Map<Integer, Integer> localSpecialObjects;
    private Map<String, String> fieldSpecialObjects;
    private boolean sawTernary;
    private boolean isInnerClass;

    protected MissingMethodsDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitClassContext(ClassContext classContext) {
        try {
            String clsName = classContext.getJavaClass().getClassName();
            this.isInnerClass = clsName.contains("$");
            this.clsSignature = "L" + clsName.replace('.', '/') + ";";
            this.stack = new OpcodeStack();
            this.localSpecialObjects = new HashMap<Integer, Integer>();
            this.fieldSpecialObjects = new HashMap<String, String>();
            super.visitClassContext(classContext);
            if (!this.isInnerClass && this.fieldSpecialObjects.size() > 0) {
                for (Map.Entry<String, String> entry : this.fieldSpecialObjects.entrySet()) {
                    String fieldName = entry.getKey();
                    String signature = entry.getValue();
                    this.bugReporter.reportBug(this.makeFieldBugInstance().addClass((PreorderVisitor)this).addField(clsName, fieldName, signature, false));
                }
            }
        }
        finally {
            this.stack = null;
            this.localSpecialObjects = null;
            this.fieldSpecialObjects = null;
        }
    }

    public void visitField(Field obj) {
        String type;
        String sig;
        if (!this.isInnerClass && obj.isPrivate() && !obj.isSynthetic() && (sig = obj.getSignature()).startsWith("L") && this.doesObjectNeedToBeWatched(type = sig.substring(1, sig.length() - 1).replace('/', '.'))) {
            this.fieldSpecialObjects.put(obj.getName(), obj.getSignature());
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.localSpecialObjects.clear();
        this.sawTernary = false;
        super.visitCode(obj);
        for (Integer pc : this.localSpecialObjects.values()) {
            this.bugReporter.reportBug(this.makeLocalBugInstance().addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this, pc.intValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        OpcodeStack.Item item;
        Object userObject = null;
        if (this.stack.getStackDepth() > 0) {
            userObject = this.stack.getStackItem(0).getUserValue();
        }
        this.stack.precomputation((DismantleBytecode)this);
        if (this.stack.getStackDepth() > 0) {
            this.stack.getStackItem(0).setUserValue(userObject);
            userObject = null;
        }
        try {
            switch (seen) {
                case 183: {
                    userObject = this.sawInvokeSpecial(userObject);
                    return;
                }
                case 182: 
                case 185: {
                    this.sawInvokeInterfaceVirtual();
                    return;
                }
                case 184: 
                case 186: {
                    this.processMethodParms();
                    return;
                }
                case 176: {
                    if (this.stack.getStackDepth() <= 0) return;
                    item = this.stack.getStackItem(0);
                    this.clearUserValue(item);
                    return;
                }
                case 58: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    this.sawAStore(seen);
                    return;
                }
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    userObject = this.sawLoad(seen, userObject);
                    return;
                }
                case 83: {
                    if (this.stack.getStackDepth() < 3) return;
                    item = this.stack.getStackItem(0);
                    this.clearUserValue(item);
                    return;
                }
                case 181: {
                    this.sawPutField();
                    return;
                }
                case 180: {
                    userObject = this.sawGetField(userObject);
                    return;
                }
                case 179: {
                    this.sawPutStatic();
                    return;
                }
                case 178: {
                    userObject = this.sawGetStatic(userObject);
                    return;
                }
                case 167: 
                case 198: 
                case 199: {
                    if (this.stack.getStackDepth() <= 0) return;
                    item = this.stack.getStackItem(0);
                    Object uo = item.getUserValue();
                    if (uo != null && !(uo instanceof Boolean)) {
                        this.clearUserValue(item);
                    }
                    this.sawTernary = true;
                    return;
                }
            }
            return;
        }
        finally {
            TernaryPatcher.pre(this.stack, seen);
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            TernaryPatcher.post(this.stack, seen);
            if (userObject != null && this.stack.getStackDepth() > 0) {
                item = this.stack.getStackItem(0);
                item.setUserValue(userObject);
            }
            if (this.sawTernary) {
                this.handleTernary(seen);
            }
        }
    }

    private void handleTernary(int seen) {
        if ((seen == 180 || seen == 25 || seen >= 42 && seen <= 45) && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            this.clearUserValue(item);
        }
        if (seen != 167 && seen != 198 && seen != 199 && seen != 42) {
            this.sawTernary = false;
        }
    }

    private void sawPutStatic() {
        OpcodeStack.Item item;
        Object uo;
        if (this.stack.getStackDepth() > 0 && (uo = (item = this.stack.getStackItem(0)).getUserValue()) != null && !(uo instanceof Boolean)) {
            this.clearUserValue(item);
        }
    }

    private Object sawGetStatic(Object userObject) {
        String fieldName;
        XField field = this.getXFieldOperand();
        if (field != null && this.fieldSpecialObjects.containsKey(fieldName = field.getName())) {
            userObject = fieldName;
        }
        return userObject;
    }

    private void sawPutField() {
        OpcodeStack.Item item;
        Object uo;
        if (this.stack.getStackDepth() > 1 && (uo = (item = this.stack.getStackItem(0)).getUserValue()) != null && !(uo instanceof Boolean)) {
            this.clearUserValue(item);
        }
    }

    private Object sawGetField(Object userObject) {
        if (this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            String sig = item.getSignature();
            if (item.getRegisterNumber() == 0 || sig != null && sig.equals(this.clsSignature)) {
                userObject = this.sawGetStatic(userObject);
            }
        }
        return userObject;
    }

    private Object sawLoad(int seen, Object userObject) {
        int reg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
        if (this.localSpecialObjects.containsKey(reg)) {
            userObject = reg;
        }
        return userObject;
    }

    private void sawInvokeInterfaceVirtual() {
        OpcodeStack.Item item;
        Object uo;
        String sig = this.getSigConstantOperand();
        int numParms = Type.getArgumentTypes((String)sig).length;
        if (this.stack.getStackDepth() > numParms && (uo = (item = this.stack.getStackItem(numParms)).getUserValue()) != null) {
            Type t;
            String name = this.getNameConstantOperand();
            if (this.isMethodThatShouldBeCalled(name)) {
                this.clearUserValue(item);
            } else if (!"clone".equals(name) && (t = Type.getReturnType((String)sig)) != Type.VOID && !this.nextOpIsPop()) {
                this.clearUserValue(item);
            }
        }
        this.processMethodParms();
    }

    private Object sawInvokeSpecial(Object userObject) {
        String clsName;
        String methodName = this.getNameConstantOperand();
        if ("<init>".equals(methodName) && this.doesObjectNeedToBeWatched(clsName = this.getClassConstantOperand().replace('/', '.'))) {
            userObject = Boolean.TRUE;
        }
        this.processMethodParms();
        return userObject;
    }

    private void sawAStore(int seen) {
        OpcodeStack.Item item;
        Object uo;
        int depth = this.stack.getStackDepth();
        if (depth > 0 && (uo = (item = this.stack.getStackItem(0)).getUserValue()) != null) {
            if (uo instanceof Boolean) {
                int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                this.localSpecialObjects.put(reg, this.getPC());
                if (depth > 1) {
                    item = this.stack.getStackItem(1);
                    item.setUserValue((Object)reg);
                }
            } else {
                this.clearUserValue(item);
            }
        }
    }

    private boolean nextOpIsPop() {
        int nextPC = this.getNextPC();
        return this.getCode().getCode()[nextPC] == 87;
    }

    private void clearUserValue(OpcodeStack.Item item) {
        Object uo = item.getUserValue();
        if (uo instanceof Integer) {
            this.localSpecialObjects.remove(uo);
        } else if (uo instanceof String) {
            this.fieldSpecialObjects.remove(uo);
        } else if (uo instanceof Boolean) {
            this.localSpecialObjects.remove(item.getRegisterNumber());
        }
        item.setUserValue(null);
    }

    protected OpcodeStack getStack() {
        return this.stack;
    }

    protected void processMethodParms() {
        String sig = this.getSigConstantOperand();
        int numParms = Type.getArgumentTypes((String)sig).length;
        if (numParms > 0 && this.stack.getStackDepth() >= numParms) {
            for (int i = 0; i < numParms; ++i) {
                this.clearUserValue(this.stack.getStackItem(i));
            }
        }
    }

    protected void clearSpecialField(String name) {
        this.fieldSpecialObjects.remove(name);
    }

    protected abstract BugInstance makeFieldBugInstance();

    protected abstract BugInstance makeLocalBugInstance();

    protected abstract boolean doesObjectNeedToBeWatched(String var1);

    protected abstract boolean isMethodThatShouldBeCalled(String var1);
}

