/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.ImmutabilityType;
import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.CollectionUtils;
import com.mebigfatguy.fbcontrib.utils.Values;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;

@OpcodeStack.CustomUserValue
public class ModifyingUnmodifiableCollection
extends BytecodeScanningDetector {
    private static Map<String, Integer> MODIFYING_METHODS = null;
    private final BugReporter bugReporter;
    private OpcodeStack stack;
    private ImmutabilityType reportedType;

    public ModifyingUnmodifiableCollection(BugReporter reporter) {
        this.bugReporter = reporter;
    }

    public void visitClassContext(ClassContext context) {
        try {
            this.stack = new OpcodeStack();
            super.visitClassContext(context);
        }
        finally {
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.reportedType = ImmutabilityType.UNKNOWN;
        super.visitCode(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sawOpcode(int seen) {
        if (this.reportedType == ImmutabilityType.IMMUTABLE) {
            return;
        }
        ImmutabilityType imType = null;
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    OpcodeStack.Item item;
                    ImmutabilityType type;
                    Integer collectionOffset;
                    String className = this.getClassConstantOperand();
                    String methodName = this.getNameConstantOperand();
                    String signature = this.getSigConstantOperand();
                    MethodInfo mi = Statistics.getStatistics().getMethodStatistics(className, methodName, signature);
                    imType = mi.getImmutabilityType();
                    if (seen != 185 || (collectionOffset = MODIFYING_METHODS.get(methodName + signature)) == null || !CollectionUtils.isListSetMap(className) || this.stack.getStackDepth() <= collectionOffset || (type = (ImmutabilityType)((Object)(item = this.stack.getStackItem(collectionOffset.intValue())).getUserValue())) != ImmutabilityType.IMMUTABLE && (type != ImmutabilityType.POSSIBLY_IMMUTABLE || this.reportedType == ImmutabilityType.POSSIBLY_IMMUTABLE)) break;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.MUC_MODIFYING_UNMODIFIABLE_COLLECTION.name(), type == ImmutabilityType.IMMUTABLE ? 1 : 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.reportedType = type;
                    break;
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            try {
                this.bugReporter.reportMissingClass(cnfe);
            }
            catch (Throwable throwable) {
                this.stack.sawOpcode((DismantleBytecode)this, seen);
                if (imType != null && this.stack.getStackDepth() > 0) {
                    OpcodeStack.Item item = this.stack.getStackItem(0);
                    item.setUserValue(imType);
                }
                throw throwable;
            }
            this.stack.sawOpcode((DismantleBytecode)this, seen);
            if (imType != null && this.stack.getStackDepth() > 0) {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                item.setUserValue((Object)imType);
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (imType != null && this.stack.getStackDepth() > 0) {
            OpcodeStack.Item item = this.stack.getStackItem(0);
            item.setUserValue((Object)imType);
        }
    }

    static {
        MODIFYING_METHODS = new HashMap<String, Integer>();
        MODIFYING_METHODS.put("add(Ljava/lang/Object;)Z", Values.ONE);
        MODIFYING_METHODS.put("remove(Ljava/lang/Object;)Z", Values.ONE);
        MODIFYING_METHODS.put("addAll(Ljava/util/Collection;)Z", Values.ONE);
        MODIFYING_METHODS.put("retainAll(Ljava/util/Collection;)Z", Values.ONE);
        MODIFYING_METHODS.put("removeAll(Ljava/util/Collection;)Z", Values.ONE);
        MODIFYING_METHODS.put("put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", Values.TWO);
        MODIFYING_METHODS.put("remove(Ljava/lang/Object;)Ljava/lang/Object;", Values.ONE);
        MODIFYING_METHODS.put("putAll(Ljava/util/Map;)V;", Values.ONE);
    }
}

