/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.collect.MethodInfo;
import com.mebigfatguy.fbcontrib.collect.Statistics;
import com.mebigfatguy.fbcontrib.collect.StatisticsKey;
import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class OverlyPermissiveMethod
extends BytecodeScanningDetector {
    private static Map<Integer, String> DECLARED_ACCESS = new HashMap<Integer, String>();
    private BugReporter bugReporter;
    private OpcodeStack stack;
    private String callingPackage;
    private String callingClass;

    public OverlyPermissiveMethod(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            ClassDescriptor cd = classContext.getClassDescriptor();
            this.callingClass = cd.getClassName();
            this.callingPackage = cd.getPackageName();
            this.stack = new OpcodeStack();
            super.visitClassContext(classContext);
        }
        finally {
            this.callingPackage = null;
            this.stack = null;
        }
    }

    public void visitCode(Code obj) {
        if (!this.hasRuntimeAnnotations(this.getMethod())) {
            this.stack.resetForMethodEntry((DismantleBytecode)this);
            super.visitCode(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sawOpcode(int seen) {
        try {
            this.stack.precomputation((DismantleBytecode)this);
            switch (seen) {
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    String calledClass = this.getClassConstantOperand();
                    String sig = this.getSigConstantOperand();
                    MethodInfo mi = Statistics.getStatistics().getMethodStatistics(calledClass, this.getNameConstantOperand(), sig);
                    if (mi == null) return;
                    if (seen == 185) {
                        mi.addCallingAccess(1);
                        return;
                    }
                    int slashPos = calledClass.lastIndexOf(47);
                    String calledPackage = slashPos >= 0 ? calledClass.substring(0, slashPos) : "";
                    boolean sameClass = calledClass.equals(this.callingClass);
                    boolean samePackage = calledPackage.equals(this.callingPackage);
                    if (sameClass) {
                        mi.addCallingAccess(2);
                        return;
                    }
                    if (samePackage) {
                        mi.addCallingAccess(0);
                        return;
                    }
                    if (seen == 184) {
                        mi.addCallingAccess(1);
                        return;
                    }
                    if (this.isCallingOnThis(sig)) {
                        mi.addCallingAccess(4);
                        return;
                    }
                    mi.addCallingAccess(1);
                    return;
                }
            }
            return;
        }
        finally {
            this.stack.sawOpcode((DismantleBytecode)this, seen);
        }
    }

    private boolean hasRuntimeAnnotations(Method obj) {
        AnnotationEntry[] annotations = obj.getAnnotationEntries();
        if (annotations != null) {
            for (AnnotationEntry entry : annotations) {
                if (!entry.isRuntimeVisible()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isCallingOnThis(String sig) {
        Type[] argTypes = Type.getArgumentTypes((String)sig);
        if (this.stack.getStackDepth() < argTypes.length) {
            return false;
        }
        OpcodeStack.Item item = this.stack.getStackItem(argTypes.length);
        return item.getRegisterNumber() == 0;
    }

    public void report() {
        for (Map.Entry<StatisticsKey, MethodInfo> entry : Statistics.getStatistics()) {
            MethodInfo mi = entry.getValue();
            int declaredAccess = mi.getDeclaredAccess();
            if ((declaredAccess & 2) != 0 || mi.wasCalledPublicly() || !mi.wasCalled()) continue;
            StatisticsKey key = entry.getKey();
            if (!OverlyPermissiveMethod.isOverlyPermissive(declaredAccess)) continue;
            try {
                if (this.isDerived(Repository.lookupClass((String)key.getClassName()), key)) continue;
                BugInstance bi = new BugInstance((Detector)this, BugType.OPM_OVERLY_PERMISSIVE_METHOD.name(), 3).addClass(key.getClassName()).addMethod(key.getClassName(), key.getMethodName(), key.getSignature(), (declaredAccess & 8) != 0);
                String descr = String.format("- Method declared %s but could be declared %s", OverlyPermissiveMethod.getDeclaredAccessValue(declaredAccess), OverlyPermissiveMethod.getRequiredAccessValue(mi));
                bi.addString(descr);
                this.bugReporter.reportBug(bi);
            }
            catch (ClassNotFoundException cnfe) {
                this.bugReporter.reportMissingClass(cnfe);
            }
        }
    }

    private static boolean isOverlyPermissive(int declaredAccess) {
        return (declaredAccess & 1) != 0;
    }

    private boolean isDerived(JavaClass cls, StatisticsKey key) {
        try {
            for (JavaClass infCls : cls.getInterfaces()) {
                for (Method infMethod : infCls.getMethods()) {
                    if (!key.getMethodName().equals(infMethod.getName()) || !(infMethod.getGenericSignature() != null ? SignatureUtils.compareGenericSignature(infMethod.getGenericSignature(), key.getSignature()) : infMethod.getSignature().equals(key.getSignature()))) continue;
                    return true;
                }
            }
            JavaClass superClass = cls.getSuperClass();
            if (superClass == null || "java.lang.Object".equals(superClass.getClassName())) {
                return false;
            }
            for (Method superMethod : superClass.getMethods()) {
                if (!key.getMethodName().equals(superMethod.getName()) || !(superMethod.getGenericSignature() != null ? SignatureUtils.compareGenericSignature(superMethod.getGenericSignature(), key.getSignature()) : superMethod.getSignature().equals(key.getSignature()))) continue;
                return true;
            }
            return this.isDerived(superClass, key);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
            return true;
        }
    }

    private static String getDeclaredAccessValue(int declaredAccess) {
        return DECLARED_ACCESS.get(declaredAccess & 7);
    }

    private static Object getRequiredAccessValue(MethodInfo mi) {
        if (mi.wasCalledProtectedly()) {
            return "protected";
        }
        if (mi.wasCalledPackagely()) {
            return "package private";
        }
        return "private";
    }

    static {
        DECLARED_ACCESS.put(2, "private");
        DECLARED_ACCESS.put(4, "protected");
        DECLARED_ACCESS.put(1, "public");
        DECLARED_ACCESS.put(0, "package private");
    }
}

