/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class OverzealousCasting
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    State state;
    LocalVariableTable lvt;
    String castClass;

    public OverzealousCasting(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitCode(Code obj) {
        this.state = State.SAW_NOTHING;
        this.lvt = obj.getLocalVariableTable();
        if (this.lvt != null && this.prescreen(this.getMethod())) {
            super.visitCode(obj);
        }
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(192);
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case SAW_NOTHING: {
                if (seen == 192) {
                    this.castClass = this.getClassConstantOperand();
                    this.state = State.SAW_CHECKCAST;
                    break;
                }
                if (seen != 185) break;
                String clsName = this.getClassConstantOperand();
                String methodName = this.getNameConstantOperand();
                if (!"java/util/Iterator".equals(clsName) || !"next".equals(methodName)) break;
                this.state = State.SAW_NEXT;
                break;
            }
            case SAW_CHECKCAST: {
                if (seen == 58 || seen >= 75 && seen <= 78) {
                    int reg = RegisterUtils.getAStoreReg((DismantleBytecode)this, seen);
                    LocalVariable lv = this.lvt.getLocalVariable(reg, this.getNextPC());
                    if (lv != null) {
                        String sig = lv.getSignature();
                        if (sig.charAt(0) == 'L') {
                            sig = sig.substring(1, sig.length() - 1);
                        }
                        if (!sig.equals(this.castClass)) {
                            this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.OC_OVERZEALOUS_CASTING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                        }
                    }
                } else if (seen == 181) {
                    FieldAnnotation f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
                    String sig = f.getFieldSignature();
                    if (sig.charAt(0) == 'L') {
                        sig = sig.substring(1, sig.length() - 1);
                    }
                    if (!sig.equals(this.castClass)) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.OC_OVERZEALOUS_CASTING.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                this.state = State.SAW_NOTHING;
                break;
            }
            default: {
                this.state = State.SAW_NOTHING;
            }
        }
    }

    static enum State {
        SAW_NOTHING,
        SAW_NEXT,
        SAW_CHECKCAST;

    }
}

