/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import com.mebigfatguy.fbcontrib.utils.OpcodeUtils;
import com.mebigfatguy.fbcontrib.utils.RegisterUtils;
import com.mebigfatguy.fbcontrib.utils.SignatureUtils;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class PoorlyDefinedParameter
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    Map<Integer, String> parmSigs;
    Map<Integer, BugInfo> bugs;
    int loadedReg;
    String parmSig;
    State state;
    String castClass;
    int downwardBranchTarget;

    public PoorlyDefinedParameter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitCode(Code obj) {
        try {
            Method m = this.getMethod();
            if (m.isStatic() || m.isPrivate() || "<init>".equals(m.getName())) {
                this.parmSigs = SignatureUtils.getParameterSignatures(m);
                if (this.parmSigs.size() > 0 && this.prescreen(m)) {
                    this.state = State.SAW_NOTHING;
                    this.bugs = new HashMap<Integer, BugInfo>();
                    this.downwardBranchTarget = -1;
                    super.visitCode(obj);
                    for (BugInfo bi : this.bugs.values()) {
                        this.bugReporter.reportBug(bi.bug);
                    }
                }
            }
        }
        finally {
            this.bugs = null;
        }
    }

    private boolean prescreen(Method method) {
        BitSet bytecodeSet = this.getClassContext().getBytecodeSet(method);
        return bytecodeSet != null && bytecodeSet.get(192);
    }

    public void sawOpcode(int seen) {
        if (this.downwardBranchTarget == -1) {
            switch (this.state) {
                case SAW_NOTHING: {
                    if (!OpcodeUtils.isALoad(seen)) break;
                    this.loadedReg = RegisterUtils.getALoadReg((DismantleBytecode)this, seen);
                    this.parmSig = this.parmSigs.get(this.loadedReg);
                    if (this.parmSig == null) break;
                    this.parmSig = this.parmSig.substring(1, this.parmSig.length() - 1);
                    this.state = State.SAW_LOAD;
                    break;
                }
                case SAW_LOAD: {
                    if (seen == 192) {
                        this.castClass = this.getClassConstantOperand();
                        if (!this.castClass.equals(this.parmSig)) {
                            this.state = State.SAW_CHECKCAST;
                            return;
                        }
                    } else if (seen == 193) {
                        this.parmSigs.remove(this.loadedReg);
                    }
                    this.state = State.SAW_NOTHING;
                    break;
                }
                case SAW_CHECKCAST: {
                    if (seen == 181 || seen == 58 || seen >= 75 && seen <= 78) {
                        LocalVariable lv;
                        String parmName = null;
                        LocalVariableTable lvt = this.getMethod().getLocalVariableTable();
                        if (lvt != null && (lv = lvt.getLocalVariable(this.loadedReg, 1)) != null) {
                            parmName = lv.getName();
                        }
                        if (parmName == null) {
                            parmName = "(" + this.loadedReg + ")";
                        }
                        BugInstance bug = new BugInstance((Detector)this, BugType.PDP_POORLY_DEFINED_PARAMETER.name(), 2).addClass((PreorderVisitor)this).addMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this).addString(parmName);
                        Integer lr = this.loadedReg;
                        BugInfo bi = this.bugs.get(lr);
                        if (bi == null) {
                            this.bugs.put(lr, new BugInfo(this.castClass, bug));
                        } else if (!bi.castClass.equals(this.castClass)) {
                            this.bugs.remove(lr);
                        }
                    }
                    this.state = State.SAW_NOTHING;
                }
            }
            int insTarget = -1;
            if (seen >= 153 && seen <= 166 || seen == 167 || seen == 200) {
                insTarget = this.getBranchTarget();
                if (insTarget < this.getPC()) {
                    insTarget = -1;
                }
            } else if (seen == 171 || seen == 170) {
                insTarget = this.getDefaultSwitchOffset() + this.getPC();
            }
            if (insTarget > this.downwardBranchTarget) {
                this.downwardBranchTarget = insTarget;
            }
        } else {
            this.state = State.SAW_NOTHING;
            if (this.getPC() >= this.downwardBranchTarget) {
                this.downwardBranchTarget = -1;
            }
        }
    }

    private static class BugInfo {
        String castClass;
        BugInstance bug;

        BugInfo(String cast, BugInstance bi) {
            this.castClass = cast;
            this.bug = bi;
        }
    }

    static enum State {
        SAW_NOTHING,
        SAW_LOAD,
        SAW_CHECKCAST;

    }
}

