/*
 * Decompiled with CFR 0.152.
 */
package com.mebigfatguy.fbcontrib.detect;

import com.mebigfatguy.fbcontrib.utils.BugType;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class PossibleIncompleteSerialization
implements Detector {
    private final BugReporter bugReporter;

    public PossibleIncompleteSerialization(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass superCls;
            JavaClass cls = classContext.getJavaClass();
            if (PossibleIncompleteSerialization.isSerializable(cls) && !PossibleIncompleteSerialization.isSerializable(superCls = cls.getSuperClass()) && PossibleIncompleteSerialization.hasSerializableFields(superCls) && !PossibleIncompleteSerialization.hasSerializingMethods(cls)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, BugType.PIS_POSSIBLE_INCOMPLETE_SERIALIZATION.name(), 2).addClass(cls));
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private static boolean isSerializable(JavaClass cls) throws ClassNotFoundException {
        JavaClass[] infs;
        for (JavaClass inf : infs = cls.getAllInterfaces()) {
            String clsName = inf.getClassName();
            if (!"java.io.Serializable".equals(clsName) && !"java.io.Externalizable".equals(clsName)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSerializableFields(JavaClass cls) {
        Field[] fields;
        for (Field f : fields = cls.getFields()) {
            if (f.isStatic() || f.isTransient() || f.isSynthetic()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSerializingMethods(JavaClass cls) {
        Method[] methods;
        for (Method m : methods = cls.getMethods()) {
            if (m.isStatic()) continue;
            String methodName = m.getName();
            String methodSig = m.getSignature();
            if ("writeObject".equals(methodName) && "(Ljava/io/ObjectOutputStream;)V".equals(methodSig)) {
                return true;
            }
            if (!"writeExternal".equals(methodName) || !"(Ljava/io/ObjectOutput;)V".equals(methodSig)) continue;
            return true;
        }
        return false;
    }

    public void report() {
    }
}

